/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.helper;

import com.sun.jaspic.config.delegate.MessagePolicyDelegate;
import com.sun.jaspic.config.helper.AuthConfigHelper;
import com.sun.jaspic.config.helper.AuthContextHelper;
import com.sun.jaspic.config.helper.EpochCarrier;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.module.ClientAuthModule;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class ClientAuthConfigHelper
extends AuthConfigHelper
implements ClientAuthConfig {
    static final AuthStatus[] vR_SuccessValue = new AuthStatus[]{AuthStatus.SUCCESS};
    static final AuthStatus[] sR_SuccessValue = new AuthStatus[]{AuthStatus.SEND_SUCCESS};
    HashMap<String, HashMap<Integer, ClientAuthContext>> contextMap;
    AuthContextHelper acHelper;

    protected ClientAuthConfigHelper(String loggerName, EpochCarrier providerEpoch, AuthContextHelper acHelper, MessagePolicyDelegate mpDelegate, String layer, String appContext, CallbackHandler cbh) throws AuthException {
        super(loggerName, providerEpoch, mpDelegate, layer, appContext, cbh);
        this.acHelper = acHelper;
    }

    @Override
    protected void initializeContextMap() {
        this.contextMap = new HashMap();
    }

    protected void refreshContextHelper() {
        this.acHelper.refresh();
    }

    protected ClientAuthContext createAuthContext(final String authContextID, final Map properties) throws AuthException {
        if (!this.acHelper.isProtected(new ClientAuthModule[0], authContextID)) {
            return null;
        }
        ClientAuthContext rvalue = new ClientAuthContext(){
            ClientAuthModule[] module = this.init();

            ClientAuthModule[] init() throws AuthException {
                ClientAuthModule[] m;
                try {
                    m = ClientAuthConfigHelper.this.acHelper.getModules(new ClientAuthModule[0], authContextID);
                }
                catch (AuthException ae) {
                    ClientAuthConfigHelper.this.logIfLevel(Level.SEVERE, ae, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigHelper.this.getAppContext(), "unable to load client auth modules");
                    throw ae;
                }
                MessagePolicy requestPolicy = ClientAuthConfigHelper.this.mpDelegate.getRequestPolicy(authContextID, properties);
                MessagePolicy responsePolicy = ClientAuthConfigHelper.this.mpDelegate.getResponsePolicy(authContextID, properties);
                boolean noModules = true;
                for (int i = 0; i < m.length; ++i) {
                    if (m[i] == null) continue;
                    if (ClientAuthConfigHelper.this.isLoggable(Level.FINE)) {
                        ClientAuthConfigHelper.this.logIfLevel(Level.FINE, null, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigHelper.this.getAppContext(), "initializing module");
                    }
                    noModules = false;
                    ClientAuthConfigHelper.this.checkMessageTypes(m[i].getSupportedMessageTypes());
                    m[i].initialize(requestPolicy, responsePolicy, ClientAuthConfigHelper.this.cbh, ClientAuthConfigHelper.this.acHelper.getInitProperties(i, properties));
                }
                if (noModules) {
                    ClientAuthConfigHelper.this.logIfLevel(Level.WARNING, null, "CLientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigHelper.this.getAppContext(), "contains no Auth Modules");
                }
                return m;
            }

            public AuthStatus validateResponse(MessageInfo arg0, Subject arg1, Subject arg2) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ClientAuthConfigHelper.this.isLoggable(Level.FINE)) {
                        ClientAuthConfigHelper.this.logIfLevel(Level.FINE, null, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigHelper.this.getAppContext(), "calling vaidateResponse on module");
                    }
                    status[i] = this.module[i].validateResponse(arg0, arg1, arg2);
                    if (!ClientAuthConfigHelper.this.acHelper.exitContext(vR_SuccessValue, i, status[i])) continue;
                    return ClientAuthConfigHelper.this.acHelper.getReturnStatus(vR_SuccessValue, AuthStatus.SEND_FAILURE, status, i);
                }
                return ClientAuthConfigHelper.this.acHelper.getReturnStatus(vR_SuccessValue, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            public AuthStatus secureRequest(MessageInfo arg0, Subject arg1) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ClientAuthConfigHelper.this.isLoggable(Level.FINE)) {
                        ClientAuthConfigHelper.this.logIfLevel(Level.FINE, null, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigHelper.this.getAppContext(), "calling secureResponse on module");
                    }
                    status[i] = this.module[i].secureRequest(arg0, arg1);
                    if (!ClientAuthConfigHelper.this.acHelper.exitContext(sR_SuccessValue, i, status[i])) continue;
                    return ClientAuthConfigHelper.this.acHelper.getReturnStatus(sR_SuccessValue, AuthStatus.SEND_FAILURE, status, i);
                }
                return ClientAuthConfigHelper.this.acHelper.getReturnStatus(sR_SuccessValue, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            public void cleanSubject(MessageInfo arg0, Subject arg1) throws AuthException {
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ClientAuthConfigHelper.this.isLoggable(Level.FINE)) {
                        ClientAuthConfigHelper.this.logIfLevel(Level.FINE, null, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigHelper.this.getAppContext(), "calling cleanSubject on module");
                    }
                    this.module[i].cleanSubject(arg0, arg1);
                }
            }
        };
        return rvalue;
    }

    public ClientAuthContext getAuthContext(String authContextID, Subject subject, Map properties) throws AuthException {
        return (ClientAuthContext)super.getContext(this.contextMap, authContextID, subject, properties);
    }

    public boolean isProtected() {
        return !this.acHelper.returnsNullContexts() || this.mpDelegate.isProtected();
    }
}

