/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.jaas;

import com.sun.jaspic.config.helper.AuthConfigProviderHelper;
import com.sun.jaspic.config.helper.AuthContextHelper;
import com.sun.jaspic.config.jaas.ExtendedConfigFile;
import com.sun.jaspic.config.jaas.JAASAuthContextHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAASAuthConfigProvider
extends AuthConfigProviderHelper {
    private static final String CONFIG_FILE_NAME_KEY = "config.file.name";
    private static final String DEFAULT_JAAS_APP_NAME = "other";
    private static final String ALL_APPS = "*";
    private String configFileName;
    private ExtendedConfigFile jaasConfig;
    private Map<String, ?> properties;
    private AuthConfigFactory factory;

    public JAASAuthConfigProvider(Map properties, AuthConfigFactory factory) {
        this.properties = properties;
        this.factory = factory;
        this.configFileName = this.getProperty(CONFIG_FILE_NAME_KEY, null);
        if (this.configFileName == null) {
            this.jaasConfig = new ExtendedConfigFile();
        } else {
            try {
                URI uri = new URI(this.configFileName);
                this.jaasConfig = new ExtendedConfigFile(uri);
            }
            catch (URISyntaxException use) {
                IllegalArgumentException iae = new IllegalArgumentException(use);
                throw iae;
            }
        }
        this.selfRegister();
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.properties;
    }

    @Override
    public AuthConfigFactory getFactory() {
        return this.factory;
    }

    private AuthConfigFactory.RegistrationContext getRegistrationContext(String id) {
        final String layer = this.getLayer();
        final String appContext = id.toLowerCase().equals(DEFAULT_JAAS_APP_NAME) ? ALL_APPS : id;
        return new AuthConfigFactory.RegistrationContext(){
            final String description;
            {
                this.description = "JAAS AuthConfig: " + appContext;
            }

            public String getMessageLayer() {
                return layer;
            }

            public String getAppContext() {
                return appContext;
            }

            public String getDescription() {
                return this.description;
            }

            public boolean isPersistent() {
                return false;
            }
        };
    }

    @Override
    public AuthConfigFactory.RegistrationContext[] getSelfRegistrationContexts() {
        String[] appContexts = this.jaasConfig.getAppNames(this.getModuleTypes());
        AuthConfigFactory.RegistrationContext[] rvalue = new AuthConfigFactory.RegistrationContext[appContexts.length];
        for (int i = 0; i < appContexts.length; ++i) {
            rvalue[i] = this.getRegistrationContext(appContexts[i]);
        }
        return rvalue;
    }

    @Override
    public AuthContextHelper getAuthContextHelper(String appContext, boolean returnNullContexts) throws AuthException {
        return new JAASAuthContextHelper(this.getLoggerName(), returnNullContexts, this.jaasConfig, this.properties, appContext);
    }

    @Override
    public void refresh() {
        this.jaasConfig.refresh();
        super.refresh();
    }
}

