/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class GSSUtils {
    private static final Logger _logger;
    public static final ObjectIdentifier GSSUP_MECH_OID;
    public static final ObjectIdentifier GSS_NT_EXPORT_NAME_OID;
    public static final ObjectIdentifier GSS_NT_SCOPED_USERNAME_OID;
    private static byte[] mech;

    public static String dumpHex(byte[] octets) {
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < octets.length; ++i) {
            String hex;
            int b;
            if (i != 0 && i % 16 == 0) {
                result.append("\n    ");
            }
            if ((b = octets[i]) < 0) {
                b = 256 + b;
            }
            if ((hex = Integer.toHexString(b)).length() == 1) {
                hex = "0" + hex;
            }
            result.append(hex + " ");
        }
        return result.toString();
    }

    public static byte[] importName(ObjectIdentifier oid, byte[] externalName) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Attempting to import mechanism independent name");
            _logger.log(Level.FINE, GSSUtils.dumpHex(externalName));
        }
        IOException e = new IOException("Invalid Name");
        if (externalName[0] != 4) {
            throw e;
        }
        if (externalName[1] != 1) {
            throw e;
        }
        int mechoidlen = (externalName[2] << 8) + (externalName[3] & 0xFF);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mech OID length = " + mechoidlen);
        }
        if (externalName.length < 4 + mechoidlen + 4) {
            throw e;
        }
        byte[] deroid = new byte[mechoidlen];
        System.arraycopy(externalName, 4, deroid, 0, mechoidlen);
        ObjectIdentifier oid1 = GSSUtils.getOID(deroid);
        if (!oid1.equals(oid)) {
            throw e;
        }
        int pos = 4 + mechoidlen;
        int namelen = (externalName[pos] << 24) + (externalName[pos + 1] << 16) + (externalName[pos + 2] << 8) + externalName[pos + 3];
        pos += 4;
        if (externalName.length != 4 + mechoidlen + 4 + namelen) {
            throw e;
        }
        byte[] name = new byte[externalName.length - pos];
        System.arraycopy(externalName, pos, name, 0, externalName.length - pos);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mechanism specific name:");
            _logger.log(Level.FINE, GSSUtils.dumpHex(name));
            _logger.log(Level.FINE, "Successfully imported mechanism independent name");
        }
        return name;
    }

    public static boolean verifyMechOID(ObjectIdentifier oid, byte[] externalName) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Attempting to verify mechanism independent name");
            _logger.log(Level.FINE, GSSUtils.dumpHex(externalName));
        }
        IOException e = new IOException("Invalid Name");
        if (externalName[0] != 4) {
            throw e;
        }
        if (externalName[1] != 1) {
            throw e;
        }
        int mechoidlen = (externalName[2] << 8) + (externalName[3] & 0xFF);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mech OID length = " + mechoidlen);
        }
        if (externalName.length < 4 + mechoidlen + 4) {
            throw e;
        }
        byte[] deroid = new byte[mechoidlen];
        System.arraycopy(externalName, 4, deroid, 0, mechoidlen);
        ObjectIdentifier oid1 = GSSUtils.getOID(deroid);
        return oid1.equals(oid);
    }

    public static byte[] createExportedName(ObjectIdentifier oid, byte[] extName) throws IOException {
        byte[] oidDER = GSSUtils.getDER(oid);
        int tokensize = 4 + oidDER.length + 4 + extName.length;
        byte[] token = new byte[tokensize];
        int pos = 0;
        token[0] = 4;
        token[1] = 1;
        token[2] = (byte)(oidDER.length & 0xFF00);
        token[3] = (byte)(oidDER.length & 0xFF);
        pos = 4;
        System.arraycopy(oidDER, 0, token, pos, oidDER.length);
        pos += oidDER.length;
        int namelen = extName.length;
        token[pos++] = (byte)(namelen & 0xFF000000);
        token[pos++] = (byte)(namelen & 0xFF0000);
        token[pos++] = (byte)(namelen & 0xFF00);
        token[pos++] = (byte)(namelen & 0xFF);
        System.arraycopy(extName, 0, token, pos, namelen);
        return token;
    }

    public static byte[] getDER(ObjectIdentifier id) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Returning OID in DER format");
            _logger.log(Level.FINE, "    OID = " + id.toString());
        }
        DerOutputStream dos = new DerOutputStream();
        dos.putOID(id);
        byte[] oid = dos.toByteArray();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "    DER OID: " + GSSUtils.dumpHex(oid));
        }
        return oid;
    }

    public static ObjectIdentifier getOID(byte[] derOID) throws IOException {
        DerInputStream dis = new DerInputStream(derOID);
        ObjectIdentifier oid = dis.getOID();
        return oid;
    }

    public static byte[] createMechIndToken(ObjectIdentifier mechoid, byte[] mechtok) throws IOException {
        byte[] deroid = GSSUtils.getDER(mechoid);
        byte[] token = new byte[1 + GSSUtils.getDERLengthSize(deroid.length + mechtok.length) + deroid.length + mechtok.length];
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Going to create a mechanism independent token");
        }
        int index = 0;
        token[index++] = 96;
        index = GSSUtils.writeDERLength(token, index, deroid.length + mechtok.length);
        System.arraycopy(deroid, 0, token, index, deroid.length);
        System.arraycopy(mechtok, 0, token, index += deroid.length, mechtok.length);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mechanism independent token created: ");
            _logger.log(Level.FINE, GSSUtils.dumpHex(token));
        }
        return token;
    }

    public static byte[] getMechToken(ObjectIdentifier oid, byte[] token) {
        byte[] mechtoken = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Received mechanism independent token: ");
            _logger.log(Level.FINE, GSSUtils.dumpHex(token));
        }
        try {
            int index = GSSUtils.verifyTokenHeader(oid, token);
            int mechtoklen = token.length - index;
            mechtoken = new byte[mechtoklen];
            System.arraycopy(token, index, mechtoken, 0, mechtoklen);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Mechanism specific token : ");
                _logger.log(Level.FINE, GSSUtils.dumpHex(mechtoken));
            }
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "iiop.IOexception", e);
        }
        return mechtoken;
    }

    private static int verifyTokenHeader(ObjectIdentifier oid, byte[] token) throws IOException {
        int index = 0;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Attempting to verify tokenheader in the mechanism independent token.");
        }
        if (token[index++] != 96) {
            throw new IOException("Defective Token");
        }
        int toklen = GSSUtils.readDERLength(token, index);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mech OID length + Mech specific length = " + toklen);
        }
        index += GSSUtils.getDERLengthSize(toklen);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mechanism OID index : " + index);
        }
        if (token[index] != 6) {
            throw new IOException("Defective Token");
        }
        byte[] buf = new byte[token.length - index];
        System.arraycopy(token, index, buf, 0, token.length - index);
        ObjectIdentifier mechoid = GSSUtils.getOID(buf);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Comparing mech OID in token with the expected mech OID");
            _logger.log(Level.FINE, "mech OID: " + GSSUtils.dumpHex(GSSUtils.getDER(mechoid)));
            _logger.log(Level.FINE, "expected mech OID: " + GSSUtils.dumpHex(GSSUtils.getDER(oid)));
        }
        if (!mechoid.equals(oid)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "mech OID in token does not match expected mech OID");
            }
            throw new IOException("Defective token");
        }
        int mechoidlen = GSSUtils.getDER(oid).length;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mechanism specific token index : " + index + mechoidlen);
            _logger.log(Level.FINE, "Successfully verified header in the mechanism independent token.");
        }
        return index + mechoidlen;
    }

    static int getDERLengthSize(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 256) {
            return 2;
        }
        if (length < 65536) {
            return 3;
        }
        if (length < 0x1000000) {
            return 4;
        }
        return 5;
    }

    static int writeDERLength(byte[] token, int index, int length) {
        if (length < 128) {
            token[index++] = (byte)length;
        } else {
            token[index++] = (byte)(GSSUtils.getDERLengthSize(length) + 127);
            if (length >= 0x1000000) {
                token[index++] = (byte)(length >> 24);
            }
            if (length >= 65536) {
                token[index++] = (byte)(length >> 16 & 0xFF);
            }
            if (length >= 256) {
                token[index++] = (byte)(length >> 8 & 0xFF);
            }
            token[index++] = (byte)(length & 0xFF);
        }
        return index;
    }

    static int readDERLength(byte[] token, int index) {
        int sf;
        int ret = 0;
        if (((sf = token[index++]) & 0x80) == 128) {
            for (int nooctets = sf & 0x7F; nooctets != 0; --nooctets) {
                ret = (ret << 8) + (token[index++] & 0xFF);
            }
        } else {
            ret = sf;
        }
        return ret;
    }

    public static byte[] getMechanism() {
        byte[] mechCopy = Arrays.copyOf(mech, mech.length);
        return mechCopy;
    }

    public static void main(String[] args) {
        try {
            byte[] len = new byte[]{-126, 1, -45};
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Length byte array : " + GSSUtils.dumpHex(len));
                _logger.log(Level.FINE, " Der length = " + GSSUtils.readDERLength(len, 0));
            }
            String name = "default";
            byte[] externalName = GSSUtils.createExportedName(GSSUP_MECH_OID, name.getBytes());
            byte[] m = GSSUtils.importName(GSSUP_MECH_OID, externalName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "BAR:" + new String(m));
            }
            String msg = "dummy_gss_export_sec_context";
            byte[] foo = GSSUtils.createMechIndToken(GSSUP_MECH_OID, msg.getBytes());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "FOO:" + GSSUtils.dumpHex(foo));
            }
            byte[] msg1 = GSSUtils.getMechToken(GSSUP_MECH_OID, foo);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "BAR:" + GSSUtils.dumpHex(msg1));
                _logger.log(Level.FINE, "BAR string: " + new String(msg1));
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.name_exception", e);
        }
    }

    static {
        int i;
        _logger = LogDomains.getLogger(GSSUtils.class, (String)"javax.enterprise.resource.corba");
        ObjectIdentifier x = null;
        try {
            i = "oid:2.23.130.1.1.1".indexOf(58);
            x = new ObjectIdentifier("oid:2.23.130.1.1.1".substring(i + 1));
        }
        catch (IOException e) {
            x = null;
            _logger.log(Level.SEVERE, "iiop.IOexception", e);
        }
        GSSUP_MECH_OID = x;
        try {
            i = "oid:1.3.6.1.5.6.4".indexOf(58);
            x = new ObjectIdentifier("oid:1.3.6.1.5.6.4".substring(i + 1));
        }
        catch (IOException e) {
            x = null;
            _logger.log(Level.SEVERE, "iiop.IOexception", e);
        }
        GSS_NT_EXPORT_NAME_OID = x;
        try {
            i = "oid:2.23.130.1.2.1".indexOf(58);
            x = new ObjectIdentifier("oid:2.23.130.1.2.1".substring(i + 1));
        }
        catch (IOException e) {
            x = null;
            _logger.log(Level.SEVERE, "iiop.IOexception", e);
        }
        GSS_NT_SCOPED_USERNAME_OID = x;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSUP_MECH_OID: " + GSSUtils.dumpHex(GSSUtils.getDER(GSSUP_MECH_OID)));
                _logger.log(Level.FINE, "GSS_NT_EXPORT_NAME_OID: " + GSSUtils.dumpHex(GSSUtils.getDER(GSS_NT_EXPORT_NAME_OID)));
                _logger.log(Level.FINE, "GSS_NT_SCOPED_USERNAME_OID: " + GSSUtils.dumpHex(GSSUtils.getDER(GSS_NT_SCOPED_USERNAME_OID)));
            }
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "iiop.IOexception", e);
        }
        try {
            mech = GSSUtils.getDER(GSSUP_MECH_OID);
        }
        catch (IOException io) {
            mech = null;
        }
    }
}

