/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.naming.ExternalNameNotFoundException;
import org.glassfish.resources.naming.ProxyRefAddr;

public class JndiProxyObjectFactory
implements ObjectFactory {
    private static Hashtable<ResourceInfo, Context> contextMap = new Hashtable();

    public static Context removeInitialContext(ResourceInfo resourceInfo) {
        return contextMap.remove(resourceInfo);
    }

    private Context loadInitialContext(String factoryClass, Hashtable env) {
        Object factory = ResourceUtil.loadObject((String)factoryClass);
        if (factory == null) {
            System.err.println("Cannot load external-jndi-resource factory-class '" + factoryClass + "'");
            return null;
        }
        if (!(factory instanceof InitialContextFactory)) {
            System.err.println("external-jndi-resource factory-class '" + factoryClass + "' must be of type " + "javax.naming.spi.InitialContextFactory");
            return null;
        }
        Context context = null;
        try {
            context = ((InitialContextFactory)factory).getInitialContext(env);
        }
        catch (NamingException ne) {
            System.err.println("Exception thrown creating initial context for external JNDI factory '" + factoryClass + "' " + ne.getMessage());
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        String jndiLookupName = "";
        String jndiFactoryClass = null;
        ResourceInfo resourceInfo = null;
        Reference ref = (Reference)obj;
        Enumeration<RefAddr> addrs = ref.getAll();
        while (addrs.hasMoreElements()) {
            RefAddr addr = addrs.nextElement();
            String prop = addr.getType();
            if (prop.equals("resourceInfo")) {
                resourceInfo = (ResourceInfo)addr.getContent();
                continue;
            }
            if (prop.equals("jndiLookupName")) {
                jndiLookupName = (String)addr.getContent();
                continue;
            }
            if (!prop.equals("jndiFactoryClass")) continue;
            jndiFactoryClass = (String)addr.getContent();
        }
        if (resourceInfo == null) {
            throw new NamingException("JndiProxyObjectFactory: no resourceInfo context info");
        }
        ProxyRefAddr contextAddr = (ProxyRefAddr)ref.get(resourceInfo.getName());
        Hashtable env = null;
        if (contextAddr == null || jndiFactoryClass == null || (env = (Hashtable)contextAddr.getContent()) == null) {
            throw new NamingException("JndiProxyObjectFactory: no info in the reference about the target context; contextAddr = " + contextAddr + " " + "env = " + env + " factoryClass = " + jndiFactoryClass);
        }
        Context context = contextMap.get(resourceInfo);
        if (context == null) {
            Hashtable<ResourceInfo, Context> hashtable = contextMap;
            synchronized (hashtable) {
                context = contextMap.get(resourceInfo);
                if (context == null) {
                    context = this.loadInitialContext(jndiFactoryClass, env);
                    contextMap.put(resourceInfo, context);
                }
            }
        }
        if (context == null) {
            throw new NamingException("JndiProxyObjectFactory no InitialContext" + jndiFactoryClass);
        }
        try {
            return context.lookup(jndiLookupName);
        }
        catch (NameNotFoundException e) {
            throw new ExternalNameNotFoundException(e);
        }
    }
}

