/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.util;

import java.lang.reflect.Proxy;
import javax.inject.Inject;
import org.glassfish.hk2.Descriptor;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.resources.api.ResourceDeployer;
import org.glassfish.resources.api.ResourceDeployerInfo;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

@Scoped(value=Singleton.class)
@Service
public class ResourceManagerFactory {
    @Inject
    private Habitat habitat;

    public ResourceDeployer getResourceDeployer(Object resource) {
        Object deployer;
        Inhabitant deployerInhabitant = null;
        for (Inhabitant inhabitant : this.habitat.getInhabitants(ResourceDeployerInfo.class)) {
            Descriptor desc = inhabitant.getDescriptor();
            if (desc == null || desc.getNames() == null) continue;
            if (Proxy.isProxyClass(resource.getClass()) && resource.getClass().getInterfaces() != null) {
                for (Class<?> clz : resource.getClass().getInterfaces()) {
                    if (!desc.getNames().contains(clz.getName())) continue;
                    deployerInhabitant = inhabitant;
                    break;
                }
                if (deployerInhabitant != null) break;
            }
            if (desc.getNames().contains(resource.getClass().getName())) {
                deployerInhabitant = inhabitant;
                break;
            }
            if (resource.getClass().getInterfaces() == null) continue;
            for (Class<?> clz : resource.getClass().getInterfaces()) {
                if (!desc.getNames().contains(clz.getName())) continue;
                deployerInhabitant = inhabitant;
                break;
            }
            if (deployerInhabitant == null) continue;
            break;
        }
        if (deployerInhabitant != null && (deployer = deployerInhabitant.get()) != null && deployer instanceof ResourceDeployer) {
            return (ResourceDeployer)deployer;
        }
        return null;
    }
}

