/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.util;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.resources.api.ResourceInfo;
import org.glassfish.resources.api.ResourceStatus;
import org.glassfish.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class BindableResourcesHelper {
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private ConfigBeansUtilities configBeanUtilities;
    @Inject
    private org.glassfish.resources.admin.cli.ResourceUtil resourceUtil;
    private static final String DOMAIN = "domain";
    private static Logger _logger = LogDomains.getLogger(ResourceUtil.class, (String)"javax.enterprise.resource.resourceadapter");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BindableResourcesHelper.class);
    private Server server;

    public boolean resourceExists(String jndiName, String target) {
        boolean exists = false;
        if (target.equals(DOMAIN)) {
            exists = true;
        } else if (ConfigBeansUtilities.getServerNamed((String)target) != null) {
            Server server = ConfigBeansUtilities.getServerNamed((String)target);
            exists = server.isResourceRefExists(jndiName);
        } else if (this.domain.getClusterNamed(target) != null) {
            Cluster cluster = this.domain.getClusterNamed(target);
            exists = cluster.isResourceRefExists(jndiName);
        } else {
            for (Config config : this.domain.getConfigs().getConfig()) {
                if (!config.getName().equals(target)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    public ResourceStatus validateBindableResourceForDuplicates(Resources resources, String jndiName, boolean validateResourceRef, String target, Class<? extends BindableResource> resourceTypeToValidate) {
        BindableResource duplicateResource = ResourceUtil.getBindableResourceByName(resources, jndiName);
        if (duplicateResource != null) {
            String msg = validateResourceRef && this.getResourceByClass(duplicateResource).equals(resourceTypeToValidate) ? (target.equals(DOMAIN) ? localStrings.getLocalString("duplicate.resource.found", "A {0} by name {1} already exists.", new Object[]{this.getResourceTypeName(duplicateResource), jndiName}) : (this.resourceUtil.getTargetsReferringResourceRef(jndiName).contains(target) ? localStrings.getLocalString("duplicate.resource.found.in.target", "A {0} by name {1} already exists with resource-ref in target {2}.", new Object[]{this.getResourceTypeName(duplicateResource), jndiName, target}) : localStrings.getLocalString("duplicate.resource.need.to.create.resource.ref", "A {0} named {1} already exists. If you are trying to create the existing resourceconfiguration in target {2}, please use 'create-resource-ref' command (or create resource-ref using admin console).", new Object[]{this.getResourceTypeName(duplicateResource), jndiName, target}))) : localStrings.getLocalString("duplicate.resource.found", "A {0} by name {1} already exists.", new Object[]{this.getResourceTypeName(duplicateResource), jndiName});
            return new ResourceStatus(1, msg, true);
        }
        return new ResourceStatus(0, "Validation Successful");
    }

    public Class getResourceByClass(BindableResource resource) {
        Class<?>[] interfaces;
        Class<BindableResource> type = BindableResource.class;
        if (Proxy.isProxyClass(resource.getClass()) && (interfaces = resource.getClass().getInterfaces()) != null) {
            for (Class<?> clz : interfaces) {
                if (!BindableResource.class.isAssignableFrom(clz)) continue;
                return clz;
            }
        }
        return type;
    }

    public String getResourceTypeName(BindableResource resource) {
        String type = "Resource";
        Class resourceType = this.getResourceByClass(resource);
        if (resourceType != null) {
            type = resourceType.getSimpleName();
        }
        return type;
    }

    public boolean isBindableResourceEnabled(BindableResource br) {
        boolean resourceRefEnabled = false;
        ResourceRef ref = this.getServer().getResourceRef(br.getJndiName());
        if (ref != null) {
            resourceRefEnabled = Boolean.valueOf(ref.getEnabled());
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null ref");
        }
        boolean resourceEnabled = Boolean.valueOf(br.getEnabled());
        return resourceEnabled && resourceRefEnabled;
    }

    public boolean isNonConnectorBindableResourceEnabled(BindableResource br, ResourceInfo resourceInfo) {
        boolean enabled = false;
        if (br == null) {
            return false;
        }
        boolean resourceEnabled = Boolean.valueOf(br.getEnabled());
        if (resourceInfo.getName().contains("__datasource_definition/")) {
            return resourceEnabled;
        }
        boolean refEnabled = this.isResourceReferenceEnabled(resourceInfo);
        if (refEnabled && resourceEnabled) {
            enabled = true;
        }
        return enabled;
    }

    public boolean isResourceReferenceEnabled(ResourceInfo resourceInfo) {
        String enabled = "false";
        if (ResourceUtil.isModuleScopedResource(resourceInfo) || ResourceUtil.isApplicationScopedResource(resourceInfo)) {
            ApplicationRef appRef = this.getServer().getApplicationRef(resourceInfo.getApplicationName());
            if (appRef != null) {
                enabled = appRef.getEnabled();
            } else {
                enabled = "true";
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null app-ref");
                }
            }
        } else {
            ResourceRef ref = this.getServer().getResourceRef(resourceInfo.getName());
            if (ref != null) {
                enabled = ref.getEnabled();
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null ref");
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: isResourceReferenceEnabled ref enabled ?" + enabled);
        }
        return Boolean.valueOf(enabled);
    }

    private Server getServer() {
        if (this.server == null) {
            this.server = this.domain.getServerNamed(this.environment.getInstanceName());
        }
        return this.server;
    }
}

