/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.listener;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.api.PostStartup;
import org.glassfish.resources.api.ResourceDeployer;
import org.glassfish.resources.api.ResourceInfo;
import org.glassfish.resources.api.ResourcesBinder;
import org.glassfish.resources.listener.ResourceManagerLifecycleListener;
import org.glassfish.resources.util.BindableResourcesHelper;
import org.glassfish.resources.util.ResourceManagerFactory;
import org.glassfish.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scoped(value=Singleton.class)
@Service(name="ResourceManager")
public class ResourceManager
implements PostStartup,
PostConstruct,
PreDestroy,
ConfigListener {
    private static final Logger logger = LogDomains.getLogger(ResourceManager.class, (String)"LogStrings");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceManager.class);
    @Inject
    private ResourcesBinder resourcesBinder;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private Provider<ResourceManagerLifecycleListener>[] resourceManagerLifecycleListenerProviders;
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    @Inject
    private GlassfishNamingManager namingMgr;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private Domain domain;
    @Inject
    private ClassLoaderHierarchy clh;

    public void postConstruct() {
        this.notifyListeners(ResourceManagerLifecycleListener.EVENT.STARTUP);
        this.deployResources(this.domain.getResources().getResources());
        this.addListenerToResources();
        this.addListenerToResourceRefs();
        this.addListenerToServer();
    }

    private void notifyListeners(ResourceManagerLifecycleListener.EVENT event) {
        for (int i = 0; i < this.resourceManagerLifecycleListenerProviders.length; ++i) {
            ResourceManagerLifecycleListener listener = (ResourceManagerLifecycleListener)this.resourceManagerLifecycleListenerProviders[i].get();
            listener.resourceManagerLifecycleEvent(event);
        }
    }

    private void addListenerToResources() {
        Resources resources = this.domain.getResources();
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)resources);
        bean.addListener((ConfigListener)this);
    }

    private void addListenerToServer() {
        Server server = this.domain.getServerNamed(this.environment.getInstanceName());
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)server);
        bean.addListener((ConfigListener)this);
    }

    public void deployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            if (resource instanceof BindableResource) {
                BindableResource bindableResource = (BindableResource)resource;
                if (!this.bindableResourcesHelper.isBindableResourceEnabled(bindableResource)) continue;
                ResourceInfo resourceInfo = new ResourceInfo(bindableResource.getJndiName());
                this.resourcesBinder.deployResource(resourceInfo, resource);
                continue;
            }
            if (resource instanceof ResourcePool) continue;
            try {
                this.getResourceDeployer(resource).deployResource(resource);
            }
            catch (Exception e) {
                Object[] params = new Object[]{ResourceUtil.getGenericResourceInfo(resource), e};
                logger.log(Level.WARNING, "resources.resource-manager.deploy-resource-failed", params);
            }
        }
        this.addListenerToResources(resources);
    }

    public Resources getAllResources() {
        return this.domain.getResources();
    }

    public void preDestroy() {
        this.removeListenerForAllResources();
        this.removeListenerForResources();
        this.removeListenerForResourceRefs();
        this.removeListenerForServer();
        this.notifyListeners(ResourceManagerLifecycleListener.EVENT.SHUTDOWN);
    }

    private void removeListenerForServer() {
        Server server = this.domain.getServerNamed(this.environment.getInstanceName());
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)server);
        bean.removeListener((ConfigListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            try {
                this.getResourceDeployer(resource).undeployResource(resource);
            }
            catch (Exception e) {
                Object[] params = new Object[]{ResourceUtil.getGenericResourceInfo(resource), e};
                logger.log(Level.WARNING, "resources.resource-manager.undeploy-resource-failed", params);
            }
            finally {
                this.removeListenerForResource(resource);
            }
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new PropertyChangeHandler(events), (Logger)logger);
    }

    private void addListenerToResources(Collection<Resource> resources) {
        for (Resource configuredResource : resources) {
            this.addListenerToResource(configuredResource);
        }
    }

    private void addListenerToResourceRefs() {
        for (ResourceRef ref : this.getResourceRefs()) {
            this.addListenerToResource(ref);
        }
    }

    private List<ResourceRef> getResourceRefs() {
        return this.domain.getServerNamed(this.environment.getInstanceName()).getResourceRef();
    }

    private void addListenerToResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.addListener((ConfigListener)this);
        } else if (instance instanceof ResourceRef) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.addListener((ConfigListener)this);
        }
    }

    private void removeListenerForResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.removeListener((ConfigListener)this);
        } else if (instance instanceof ResourceRef) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.removeListener((ConfigListener)this);
        }
    }

    private void removeListenerForResourceRefs() {
        for (ResourceRef ref : this.getResourceRefs()) {
            this.removeListenerForResource(ref);
        }
    }

    private void removeListenerForResources() {
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.domain.getResources());
        bean.removeListener((ConfigListener)this);
    }

    private void removeListenerForAllResources() {
        for (Resource configuredResource : this.domain.getResources().getResources()) {
            this.removeListenerForResource(configuredResource);
        }
    }

    private ResourceDeployer getResourceDeployer(Object resource) {
        return ((ResourceManagerFactory)this.resourceManagerFactoryProvider.get()).getResourceDeployer(resource);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyChangeHandler
    implements Changed {
        PropertyChangeEvent[] events;

        private PropertyChangeHandler(PropertyChangeEvent[] events) {
            this.events = events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            try {
                DelegatingClassLoader ccl = ResourceManager.this.clh.getConnectorClassLoader(null);
                Thread.currentThread().setContextClassLoader((ClassLoader)ccl);
                switch (type) {
                    case ADD: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("A new " + changedType.getName() + " was added : " + changedInstance);
                        }
                        np = this.handleAddEvent(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                        }
                        np = this.handleChangeEvent(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                        }
                        np = this.handleRemoveEvent(changedInstance);
                        break;
                    }
                    default: {
                        np = new NotProcessed("Unrecognized type of change: " + type);
                    }
                }
                NotProcessed notProcessed = np;
                return notProcessed;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            NotProcessed np = null;
            try {
                if (ResourceUtil.isValidEventType(instance)) {
                    boolean enabledAttributeChange = false;
                    if (instance instanceof BindableResource) {
                        for (PropertyChangeEvent event : this.events) {
                            String propertyName = event.getPropertyName();
                            if (!"enabled".equalsIgnoreCase(propertyName)) continue;
                            enabledAttributeChange = true;
                            BindableResource bindableResource = (BindableResource)instance;
                            ResourceDeployer deployer = ResourceManager.this.getResourceDeployer(bindableResource);
                            if (deployer == null) continue;
                            boolean newValue = Boolean.valueOf(event.getNewValue().toString());
                            boolean oldValue = Boolean.valueOf(event.getOldValue().toString());
                            if (newValue && oldValue) continue;
                            if (newValue) {
                                deployer.enableResource(bindableResource);
                                continue;
                            }
                            deployer.disableResource(bindableResource);
                        }
                    }
                    if (!enabledAttributeChange) {
                        ResourceManager.this.getResourceDeployer(instance).redeployResource(instance);
                    }
                } else if (ResourceUtil.isValidEventType(instance.getParent())) {
                    ResourceManager.this.getResourceDeployer(instance.getParent()).redeployResource(instance.getParent());
                } else if (instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    ResourceDeployer deployer = null;
                    String refName = ref.getRef();
                    BindableResource bindableResource = null;
                    for (PropertyChangeEvent event : this.events) {
                        String propertyName = event.getPropertyName();
                        if (!"enabled".equalsIgnoreCase(propertyName) || (deployer = ResourceManager.this.getResourceDeployer(bindableResource = ResourceUtil.getBindableResourceByName(ResourceManager.this.domain.getResources(), refName))) == null) continue;
                        boolean newValue = Boolean.valueOf(event.getNewValue().toString());
                        boolean oldValue = Boolean.valueOf(event.getOldValue().toString());
                        if (newValue && oldValue) continue;
                        if (newValue) {
                            deployer.enableResource(bindableResource);
                            continue;
                        }
                        deployer.disableResource(bindableResource);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "resources.resource-manager.change-event-failed", ex);
                np = new NotProcessed(localStrings.getLocalString("resources.resource-manager.change-event-failed", "Change event failed"));
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
            NotProcessed np = null;
            ResourceManager.this.addListenerToResource(instance);
            if (!(instance instanceof BindableResource) && !(instance instanceof ResourcePool)) {
                if (instance instanceof Resource) {
                    try {
                        ResourceManager.this.getResourceDeployer(instance).deployResource(instance);
                    }
                    catch (Exception e) {
                        Object[] params = new Object[]{ResourceUtil.getGenericResourceInfo((Resource)instance), e};
                        logger.log(Level.WARNING, "resources.resource-manager.deploy-resource-failed", params);
                    }
                } else if (!(instance instanceof Property) && instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    BindableResource resource = ResourceUtil.getBindableResourceByName(ResourceManager.this.domain.getResources(), ref.getRef());
                    if (Boolean.valueOf(ref.getEnabled()).booleanValue() && Boolean.valueOf(resource.getEnabled()).booleanValue()) {
                        ResourceInfo resourceInfo = new ResourceInfo(resource.getJndiName());
                        ResourceManager.this.resourcesBinder.deployResource(resourceInfo, (Resource)resource);
                    }
                }
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
            NotProcessed np = null;
            try {
                if (instance instanceof BindableResource) {
                    ResourceManager.this.removeListenerForResource(instance);
                } else if (instance instanceof Resource) {
                    ResourceManager.this.removeListenerForResource(instance);
                    ResourceManager.this.getResourceDeployer(instance).undeployResource(instance);
                } else if (ResourceUtil.isValidEventType(instance.getParent())) {
                    ResourceManager.this.getResourceDeployer(instance.getParent()).redeployResource(instance.getParent());
                } else if (instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    BindableResource resource = ResourceUtil.getBindableResourceByName(ResourceManager.this.domain.getResources(), ref.getRef());
                    ResourceManager.this.getResourceDeployer(resource).undeployResource(resource);
                    ResourceManager.this.removeListenerForResource(instance);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "resources.resource-manager.remove-event-failed");
                np = new NotProcessed(localStrings.getLocalString("resources.resource-manager.remove-event-failed", "Remove event failed"));
            }
            return np;
        }
    }
}

