/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.api;

import com.sun.enterprise.config.serverbeans.Resource;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.naming.NamingException;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.resources.api.ResourceInfo;
import org.glassfish.resources.api.ResourceProxy;
import org.glassfish.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;

@Service
public class ResourcesBinder {
    @Inject
    private GlassfishNamingManager manager;
    @Inject
    private Logger logger;
    @Inject
    private Provider<ResourceProxy> resourceProxyProvider;
    @Inject
    private ResourceNamingService resourceNamingService;

    public void deployResource(ResourceInfo resourceInfo, Resource resource) {
        try {
            this.bindResource(resourceInfo, resource);
        }
        catch (NamingException ne) {
            Object[] params = new Object[]{resourceInfo, ne};
            this.logger.log(Level.SEVERE, "resources.resources-binder.bind-resource-failed", params);
        }
    }

    private void bindResource(ResourceInfo resourceInfo, Resource resource) throws NamingException {
        ResourceProxy proxy = (ResourceProxy)this.resourceProxyProvider.get();
        proxy.setResource(resource);
        proxy.setResourceInfo(resourceInfo);
        this.resourceNamingService.publishObject(resourceInfo, proxy, true);
    }
}

