/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.admin.cli;

import com.sun.enterprise.config.serverbeans.Resources;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.glassfish.resources.admin.cli.ResourceFactory;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.admin.cli.ResourcesXMLParser;
import org.glassfish.resources.api.Resource;
import org.glassfish.resources.api.ResourceStatus;

public class ResourcesManager {
    public static ArrayList createResources(Resources resources, File resourceXMLFile, String target, ResourceFactory resourceFactory) throws Exception {
        ArrayList<ResourceStatus> results = new ArrayList<ResourceStatus>();
        ResourcesXMLParser resourcesParser = new ResourcesXMLParser(resourceXMLFile);
        List<Resource> vResources = resourcesParser.getResourcesList();
        for (Resource resource : ResourcesXMLParser.getNonConnectorResourcesList(vResources, false, false)) {
            ResourceStatus rs;
            HashMap attrList = resource.getAttributes();
            String desc = resource.getDescription();
            if (desc != null) {
                attrList.put("description", desc);
            }
            Properties props = resource.getProperties();
            try {
                ResourceManager rm = resourceFactory.getResourceManager(resource);
                rs = rm.create(resources, attrList, props, target);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                rs = new ResourceStatus(1, msg);
            }
            results.add(rs);
        }
        for (Resource resource : ResourcesXMLParser.getConnectorResourcesList(vResources, false, false)) {
            ResourceStatus rs;
            HashMap attrList = resource.getAttributes();
            String desc = resource.getDescription();
            if (desc != null) {
                attrList.put("description", desc);
            }
            Properties props = resource.getProperties();
            try {
                ResourceManager rm = resourceFactory.getResourceManager(resource);
                rs = rm.create(resources, attrList, props, target);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                rs = new ResourceStatus(1, msg);
            }
            results.add(rs);
        }
        return results;
    }
}

