/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.resources.config.ExternalJndiResource;
import org.glassfish.resources.util.BindableResourcesHelper;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-jndi-resources")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.jndi.resources")
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-jndi-resources", description="list-jndi-resources")})
public class ListJndiResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJndiResources.class);
    @Param(primary=true, optional=true, defaultValue="server")
    private String targetOperand;
    @Param(optional=true, obsolete=true)
    private String target = "server";
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ArrayList<String> list = new ArrayList<String>();
            Collection jndiResources = this.domain.getResources().getResources(ExternalJndiResource.class);
            for (ExternalJndiResource jndiResource : jndiResources) {
                if (!this.bindableResourcesHelper.resourceExists(jndiResource.getJndiName(), this.targetOperand)) continue;
                list.add(jndiResource.getJndiName());
            }
            for (String jndiName : list) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(jndiName);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.jndi.resources.fail", "Unable to list jndi resources.") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

