/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.resources.admin.cli.JndiResourceManager;
import org.glassfish.resources.api.ResourceStatus;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-jndi-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.jndi.resource")
public class CreateJndiResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJndiResource.class);
    @Param(name="restype")
    private String resType;
    @Param(name="factoryclass")
    private String factoryClass;
    @Param(name="jndilookupname")
    private String jndiLookupName;
    @Param(optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(optional=true)
    private String description;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private JndiResourceManager jndiResManager;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("factory-class", this.factoryClass);
        attrList.put("res-type", this.resType);
        attrList.put("jndi-lookup-name", this.jndiLookupName);
        attrList.put("enabled", this.enabled.toString());
        attrList.put("jndi-name", this.jndiName);
        attrList.put("description", this.description);
        try {
            rs = this.jndiResManager.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception e) {
            Logger.getLogger(CreateJndiResource.class.getName()).log(Level.SEVERE, "Unable to create jndi resource " + this.jndiName, e);
            String def = "jndi resource: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.jndi.resource.fail", def, new Object[]{this.jndiName}) + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() == null) {
                report.setMessage(localStrings.getLocalString("create.jndi.resource.fail", "jndi resource {0} creation failed", new Object[]{this.jndiName, ""}));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        report.setActionExitCode(ec);
    }
}

