/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class GenericAttribute
extends ClassAttribute {
    byte[] attributeBytes;

    public GenericAttribute(ConstUtf8 attrName, byte[] attrBytes) {
        super(attrName);
        this.attributeBytes = attrBytes;
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        out.writeInt(this.attributeBytes.length);
        out.write(this.attributeBytes, 0, this.attributeBytes.length);
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("Generic Attribute(" + this.attrName().asString() + "): " + Integer.toString(this.attributeBytes.length) + " in length");
        for (int i = 0; i < this.attributeBytes.length; ++i) {
            if (i % 16 == 0) {
                if (i != 0) {
                    out.println();
                }
                out.print(i + " :");
            }
            out.print(" " + Integer.toString(this.attributeBytes[i] & 0xFF, 16));
        }
        out.println();
    }
}

