/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer;

import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancer;
import com.sun.jdo.api.persistence.enhancer.EnhancerFatalError;
import com.sun.jdo.api.persistence.enhancer.EnhancerUserException;
import com.sun.jdo.api.persistence.enhancer.OutputStreamWrapper;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassFile;
import com.sun.jdo.api.persistence.enhancer.impl.ClassControl;
import com.sun.jdo.api.persistence.enhancer.impl.EnhancerControl;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataModelImpl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataPropertyImpl;
import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.enhancer.util.UserException;
import com.sun.jdo.api.persistence.model.Model;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class FilterEnhancer
extends Support
implements ByteCodeEnhancer {
    public static final String DO_SIMPLE_TIMING = "ByteCodeEnhancer.doSimpleTiming";
    public static final String VERBOSE_LEVEL = "ByteCodeEnhancer.verboseLevel";
    public static final String VERBOSE_LEVEL_QUIET = "quiet";
    public static final String VERBOSE_LEVEL_WARN = "warn";
    public static final String VERBOSE_LEVEL_VERBOSE = "verbose";
    public static final String VERBOSE_LEVEL_DEBUG = "debug";
    private Environment env = new Environment();
    private EnhancerControl econtrol = new EnhancerControl(this.env);

    protected void init(JDOMetaData metaData, Properties settings, PrintWriter out, PrintWriter err) throws EnhancerUserException, EnhancerFatalError {
        String verboseLevel;
        if (metaData == null) {
            throw new EnhancerFatalError(FilterEnhancer.getI18N("enhancer.internal_error", "Illegal argument: metaData == null"));
        }
        this.env.setJDOMetaData(metaData);
        if (err != null) {
            this.env.setErrorWriter(err);
        }
        if (out != null) {
            this.env.setOutputWriter(out);
        }
        String string = verboseLevel = settings == null ? null : settings.getProperty(VERBOSE_LEVEL);
        if (VERBOSE_LEVEL_QUIET.equals(verboseLevel)) {
            this.env.setVerbose(false);
            this.env.setQuiet(true);
        } else if (VERBOSE_LEVEL_WARN.equals(verboseLevel)) {
            this.env.setVerbose(false);
            this.env.setQuiet(false);
        } else if (VERBOSE_LEVEL_VERBOSE.equals(verboseLevel)) {
            this.env.setVerbose(true);
            this.env.setQuiet(false);
        } else if (VERBOSE_LEVEL_DEBUG.equals(verboseLevel)) {
            this.env.setVerbose(true);
            this.env.setQuiet(false);
        } else {
            this.env.setVerbose(false);
            this.env.setQuiet(false);
        }
        this.env.setNoOptimization(true);
        this.env.messageNL("FilterEnhancer: forced settings: -noopt");
    }

    public FilterEnhancer(JDOMetaData metaData, Properties settings, PrintWriter out, PrintWriter err) throws EnhancerUserException, EnhancerFatalError {
        this.init(metaData, settings, out, err);
    }

    public FilterEnhancer(Properties metaData, Properties settings, PrintWriter out, PrintWriter err) throws EnhancerUserException, EnhancerFatalError {
        if (metaData == null) {
            throw new EnhancerFatalError(FilterEnhancer.getI18N("enhancer.internal_error", "Illegal argument: metaData == null"));
        }
        JDOMetaDataPropertyImpl meta = new JDOMetaDataPropertyImpl(metaData, out);
        this.init(meta, settings, out, err);
    }

    public FilterEnhancer(Model metaData, Properties settings, PrintWriter out, PrintWriter err) throws EnhancerUserException, EnhancerFatalError {
        if (metaData == null) {
            throw new EnhancerFatalError(FilterEnhancer.getI18N("enhancer.internal_error", "Illegal argument: metaData == null"));
        }
        JDOMetaDataModelImpl meta = new JDOMetaDataModelImpl(metaData, this.env.getOutputWriter());
        this.init(meta, settings, out, err);
    }

    public boolean enhanceClassFile(InputStream inByteCode, OutputStreamWrapper outByteCode) throws EnhancerUserException, EnhancerFatalError {
        boolean changed;
        this.env.messageNL("FilterEnhancer: enhancing classfile ...");
        this.env.reset();
        try {
            changed = this.enhanceClassFile1(inByteCode, outByteCode);
        }
        catch (UserException ex) {
            this.env.reset();
            throw new EnhancerUserException(FilterEnhancer.getI18N("enhancer.error", ex.getMessage()), ex);
        }
        catch (RuntimeException ex) {
            this.env.reset();
            ex.printStackTrace();
            throw new EnhancerFatalError(FilterEnhancer.getI18N("enhancer.internal_error", ex.getMessage()), ex);
        }
        this.env.messageNL(changed ? "FilterEnhancer: classfile enhanced successfully." : "FilterEnhancer: classfile not changed.");
        return changed;
    }

    private boolean enhanceClassFile1(InputStream inByteCode, OutputStreamWrapper outByteCode) {
        ClassControl cc;
        ClassFile cf;
        FilterEnhancer.affirm(inByteCode, "Illegal argument: inByteCode == null.");
        FilterEnhancer.affirm(outByteCode, "Illegal argument: outByteCode == null.");
        try {
            ClassFileSource cfs = new ClassFileSource(null, inByteCode);
            DataInputStream dis = cfs.classFileContents();
            cf = new ClassFile(dis);
            cc = new ClassControl(cfs, cf, this.env);
            this.env.addClass(cc);
            String className = cc.className();
            cfs.setExpectedClassName(className);
        }
        catch (IOException ex) {
            throw new UserException(FilterEnhancer.getI18N("enhancer.io_error_while_reading_stream"), ex);
        }
        catch (ClassFormatError ex) {
            throw new UserException(FilterEnhancer.getI18N("enhancer.class_format_error"), ex);
        }
        this.econtrol.modifyClasses();
        if (this.env.errorCount() > 0) {
            this.env.getErrorWriter().flush();
            throw new UserException(this.env.getLastErrorMessage());
        }
        boolean changed = cc.updated() && cc.filterRequired();
        try {
            if (changed) {
                this.env.message("writing enhanced class " + cc.userClassName() + " to output stream");
            } else {
                this.env.message("no changes on class " + cc.userClassName());
            }
            outByteCode.setClassName(cc.userClassName());
            DataOutputStream dos = new DataOutputStream(outByteCode.getStream());
            cf.write(dos);
            dos.flush();
        }
        catch (IOException ex) {
            throw new UserException(FilterEnhancer.getI18N("enhancer.io_error_while_writing_stream"), ex);
        }
        return changed;
    }

    public boolean enhanceClassFile(InputStream in, OutputStream out) throws EnhancerUserException, EnhancerFatalError {
        return this.enhanceClassFile(in, new OutputStreamWrapper(out));
    }
}

