/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.cli.remote;

import com.sun.enterprise.admin.remote.ServerRemoteAdminCommand;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.osgi.cli.remote.impl.OsgiShellService;
import org.glassfish.osgi.cli.remote.impl.OsgiShellServiceProvider;
import org.glassfish.osgi.cli.remote.impl.SessionOperation;
import org.jvnet.hk2.annotations.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

@Service(name="osgi")
@CommandLock(value=CommandLock.LockType.SHARED)
@I18n(value="osgi")
@PerLookup
@TargetType(value={CommandTarget.CLUSTERED_INSTANCE, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="osgi", description="Remote OSGi Shell Access")})
@AccessRequired(resource={"domain/osgi/shell"}, action={"execute"})
public class OSGiShellCommand
implements AdminCommand,
PostConstruct {
    private static final Logger LOG = Logger.getLogger(OSGiShellCommand.class.getPackage().getName());
    @Param(name="command-line", primary=true, optional=true, multiple=true, defaultValue="help")
    private Object commandLine;
    @Param(name="session", optional=true, acceptableValues="new,list,execute,stop")
    private String sessionOp;
    @Param(name="session-id", optional=true)
    private String sessionId;
    @Param(name="instance", optional=true)
    private String instance;
    protected BundleContext ctx;
    @Inject
    ServiceLocator locator;
    @Inject
    Domain domain;

    public void postConstruct() {
        if (this.ctx == null) {
            Bundle me = ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle();
            this.ctx = me.getBundleContext();
        }
    }

    public void execute(AdminCommandContext context) {
        String[] list;
        String cmd;
        String cmdName;
        ActionReport report = context.getActionReport();
        if (this.instance != null) {
            Server server = this.domain.getServerNamed(this.instance);
            if (server == null) {
                report.setMessage("No server target found for " + this.instance);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            String host = server.getAdminHost();
            int port = server.getAdminPort();
            try {
                ServerRemoteAdminCommand remote = new ServerRemoteAdminCommand(this.locator, "osgi", host, port, false, "admin", "", LOG);
                ParameterMap params = new ParameterMap();
                if (this.commandLine == null) {
                    params.set((Object)"default", (Object)"asadmin-osgi-shell");
                } else if (this.commandLine instanceof String) {
                    params.set((Object)"default", (Object)((String)this.commandLine));
                } else if (this.commandLine instanceof List) {
                    params.set((Object)"default", (Collection)((List)this.commandLine));
                }
                if (this.sessionOp != null) {
                    params.set((Object)"session", (Object)this.sessionOp);
                }
                if (this.sessionId != null) {
                    params.set((Object)"session-id", (Object)this.sessionId);
                }
                report.setMessage(remote.executeCommand(params));
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
            catch (CommandException e) {
                report.setMessage("Remote execution failed: " + e.getMessage());
                report.setFailureCause((Throwable)e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.commandLine == null) {
            cmdName = "asadmin-osgi-shell";
            cmd = "asadmin-osgi-shell";
        } else if (this.commandLine instanceof String) {
            cmd = cmdName = (String)this.commandLine;
        } else if (this.commandLine instanceof List) {
            list = (String[])this.commandLine;
            cmdName = list.isEmpty() ? "" : (String)list.get(0);
            cmd = list.isEmpty() ? "" : list.stream().collect(Collectors.joining(" "));
        } else if (this.commandLine instanceof String[]) {
            list = (String[])this.commandLine;
            cmdName = list.length == 0 ? "" : list[0];
            cmd = list.length == 0 ? "" : Arrays.stream(list).collect(Collectors.joining(" "));
        } else {
            report.setMessage("Unable to deal with argument list of type " + this.commandLine.getClass().getName());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            SessionOperation sessionOperation = SessionOperation.parse(this.sessionOp);
            OsgiShellService service = OsgiShellServiceProvider.detectService(this.ctx, sessionOperation, this.sessionId, report);
            if (service == null) {
                report.setMessage("No Shell Service available");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            service.exec(cmdName, cmd);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
            report.setMessage(ex.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

