/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbcruntime.service;

import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.service.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.DriverLoader;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class JdbcAdminServiceImpl
extends ConnectorService {
    private ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService((String)"ConnectorConnectionPool");
    private static final String DBVENDOR_MAPPINGS_ROOT = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "databases" + File.separator + "dbvendormapping" + File.separator;
    private static final String JDBC40_CONNECTION_VALIDATION = "org.glassfish.api.jdbc.validation.JDBC40ConnectionValidation";
    private static final String DS_PROPERTIES = "ds.properties";
    private static final String CPDS_PROPERTIES = "cpds.properties";
    private static final String XADS_PROPERTIES = "xads.properties";
    private static final String DRIVER_PROPERTIES = "driver.properties";
    private static final String CONVAL_PROPERTIES = "validationclassnames.properties";
    private static JdbcAdminServiceImpl jdbcAdminService = new JdbcAdminServiceImpl();

    public static JdbcAdminServiceImpl getJdbcAdminService() {
        if (jdbcAdminService == null) {
            throw new RuntimeException("JDBC admin service not initialized");
        }
        return jdbcAdminService;
    }

    public Set<String> getValidationClassNames(String className) {
        TreeSet<String> classNames = new TreeSet<String>();
        if (className == null) {
            _logger.log(Level.WARNING, "jdbc.admin.service.ds_class_name_null");
            return classNames;
        }
        String dbVendor = this.getDatabaseVendorName(className);
        if (dbVendor != null) {
            File validationClassMappingFile = new File(DBVENDOR_MAPPINGS_ROOT + CONVAL_PROPERTIES);
            Properties validationClassMappings = DriverLoader.loadFile((File)validationClassMappingFile);
            String validationClassName = validationClassMappings.getProperty(dbVendor);
            if (validationClassName != null) {
                classNames.add(validationClassName);
            }
            if (this.detectJDBC40(className)) {
                classNames.add(JDBC40_CONNECTION_VALIDATION);
            }
        }
        return classNames;
    }

    private String getDatabaseVendorName(String className) {
        String dbVendor = this.getDatabaseVendorName(DriverLoader.loadFile((File)new File(DBVENDOR_MAPPINGS_ROOT + DS_PROPERTIES)), className);
        if (dbVendor == null) {
            dbVendor = this.getDatabaseVendorName(DriverLoader.loadFile((File)new File(DBVENDOR_MAPPINGS_ROOT + CPDS_PROPERTIES)), className);
        }
        if (dbVendor == null) {
            dbVendor = this.getDatabaseVendorName(DriverLoader.loadFile((File)new File(DBVENDOR_MAPPINGS_ROOT + XADS_PROPERTIES)), className);
        }
        if (dbVendor == null) {
            dbVendor = this.getDatabaseVendorName(DriverLoader.loadFile((File)new File(DBVENDOR_MAPPINGS_ROOT + DRIVER_PROPERTIES)), className);
        }
        return dbVendor;
    }

    private String getDatabaseVendorName(Properties classNameProperties, String className) {
        String dbVendor = null;
        Enumeration<?> e = classNameProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = classNameProperties.getProperty(key);
            if (!className.equalsIgnoreCase(value)) continue;
            dbVendor = key;
            break;
        }
        return dbVendor;
    }

    private boolean detectJDBC40(String className) {
        boolean jdbc40 = true;
        ClassLoader commonClassLoader = ConnectorRuntime.getRuntime().getClassLoaderHierarchy().getCommonClassLoader();
        Class<?> cls = null;
        try {
            cls = commonClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "jdbc.admin.service.ex_detect_jdbc40");
            }
            return false;
        }
        try {
            Method method = cls.getMethod("isWrapperFor", Class.class);
            method.invoke(cls.newInstance(), DataSource.class);
        }
        catch (NoSuchMethodException e) {
            jdbc40 = false;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "jdbc.admin.service.ex_detect_jdbc40");
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof AbstractMethodError) {
                jdbc40 = false;
            }
        }
        catch (InstantiationException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "jdbc.admin.service.ex_detect_jdbc40");
            }
            jdbc40 = false;
        }
        catch (IllegalAccessException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "jdbc.admin.service.ex_detect_jdbc40");
            }
            jdbc40 = false;
        }
        return jdbc40;
    }

    public Set<String> getValidationTableNames(PoolInfo poolInfo) throws ResourceException {
        ManagedConnectionFactory mcf = null;
        ManagedConnection mc = null;
        Connection con = null;
        try {
            mc = (ManagedConnection)this.ccPoolAdmService.getUnpooledConnection(poolInfo, null, false);
            mcf = this.ccPoolAdmService.obtainManagedConnectionFactory(poolInfo);
            if (mc != null) {
                con = (Connection)mc.getConnection(null, null);
            }
            Set<String> set = JdbcAdminServiceImpl.getValidationTableNames(con, this.getDefaultDatabaseName(poolInfo, mcf));
            return set;
        }
        catch (Exception re) {
            _logger.log(Level.WARNING, "pool.get_validation_table_names_failure", re.getMessage());
            throw new ResourceException((Throwable)re);
        }
        finally {
            block11: {
                try {
                    if (mc != null) {
                        mc.destroy();
                    }
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block11;
                    _logger.log(Level.FINEST, "pool.get_validation_table_names_mc_destroy", poolInfo);
                }
            }
        }
    }

    private String getDefaultDatabaseName(PoolInfo poolInfo, ManagedConnectionFactory mcf) throws NamingException {
        String databaseName = null;
        ConnectorConnectionPool connectorConnectionPool = null;
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool((PoolInfo)poolInfo);
        connectorConnectionPool = (ConnectorConnectionPool)this._runtime.getResourceNamingService().lookup((GenericResourceInfo)poolInfo, jndiNameForPool, null);
        databaseName = this.ccPoolAdmService.getPropertyValue("DATABASENAME", connectorConnectionPool);
        if (databaseName == null || databaseName.trim().equals("")) {
            databaseName = ConnectionPoolObjectsUtils.getValueFromMCF((String)"DatabaseName", (PoolInfo)poolInfo, (ManagedConnectionFactory)mcf);
        }
        return databaseName;
    }

    public static Set<String> getValidationTableNames(Connection con, String catalog) throws ResourceException {
        TreeSet<String> tableNames = new TreeSet<String>();
        if (catalog.trim().equals("")) {
            catalog = null;
        }
        if (con != null) {
            ResultSet rs = null;
            try {
                DatabaseMetaData dmd = con.getMetaData();
                rs = dmd.getTables(catalog, null, null, null);
                while (rs.next()) {
                    String tableName;
                    String schemaName = rs.getString(2);
                    String actualTableName = tableName = rs.getString(3);
                    if (schemaName != null && !schemaName.equals("")) {
                        actualTableName = schemaName + "." + tableName;
                    }
                    tableNames.add(actualTableName);
                }
            }
            catch (Exception sqle) {
                _logger.log(Level.INFO, "pool.get_validation_table_names");
                throw new ResourceException((Throwable)sqle);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e1) {}
            }
        }
        throw new ResourceException("The connection is not valid as the connection is null");
        return tableNames;
    }
}

