/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.portunif;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.config.ConfigAwareElement;
import org.glassfish.grizzly.config.dom.HttpRedirect;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class HttpRedirectFilter
extends BaseFilter
implements ConfigAwareElement {
    private Integer redirectPort;
    private Boolean secure;

    public void configure(Habitat habitat, NetworkListener networkListener, ConfigBeanProxy configuration) {
        if (configuration instanceof HttpRedirect) {
            HttpRedirect httpRedirectConfig = (HttpRedirect)configuration;
            int port = Integer.parseInt(httpRedirectConfig.getPort());
            this.redirectPort = port != -1 ? Integer.valueOf(port) : null;
            this.secure = Boolean.parseBoolean(httpRedirectConfig.getSecure());
        }
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        SSLEngine sslEngine;
        URI requestURI;
        Connection connection = ctx.getConnection();
        HttpContent httpContent = (HttpContent)ctx.getMessage();
        HttpRequestPacket request = (HttpRequestPacket)httpContent.getHttpHeader();
        try {
            String uri = request.getQueryString() == null ? request.getRequestURI() : request.getRequestURI() + "?" + request.getQueryString();
            requestURI = new URI(uri);
        }
        catch (URISyntaxException ignored) {
            return ctx.getStopAction();
        }
        boolean redirectToSecure = this.secure != null ? this.secure : (sslEngine = SSLUtils.getSSLEngine(connection)) == null;
        StringBuilder hostPort = new StringBuilder();
        String hostHeader = request.getHeader("host");
        if (hostHeader == null) {
            String hostRequestURI = requestURI.getHost();
            if (hostRequestURI == null) {
                hostPort.append(request.getLocalHost());
            } else {
                hostPort.append(hostRequestURI);
            }
            hostPort.append(':');
            if (this.redirectPort == null) {
                int port = requestURI.getPort();
                if (port == -1) {
                    hostPort.append(request.getLocalPort());
                } else {
                    hostPort.append(port);
                }
            } else {
                hostPort.append(this.redirectPort);
            }
        } else if (this.redirectPort != null) {
            int colonIdx = hostHeader.indexOf(58);
            if (colonIdx != -1) {
                hostHeader = hostHeader.substring(0, colonIdx);
            }
            hostPort.append(hostHeader).append(':').append(this.redirectPort);
        } else {
            hostPort.append(hostHeader);
        }
        if (hostPort.length() > 0) {
            String path = requestURI.toString();
            if (path == null) {
                path = "/";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(redirectToSecure ? "https://" : "http://").append((CharSequence)hostPort).append(path);
            request.setSkipRemainder(true);
            HttpResponsePacket response = ((HttpResponsePacket.Builder)((HttpResponsePacket.Builder)HttpResponsePacket.builder(request).status(302).header("Location", sb.toString())).contentLength(0L)).build();
            ctx.write(response);
        } else {
            connection.closeSilently();
        }
        return ctx.getStopAction();
    }
}

