/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.InhabitantsScanner;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.config.GrizzlyConfigException;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger LOGGER = Grizzly.logger(Utils.class);
    private static final String habitatName = "default";
    private static final String inhabitantPath = "META-INF/inhabitants";

    public static Habitat getHabitat(String fileURL) {
        Habitat habitat;
        URL url = Utils.class.getClassLoader().getResource(fileURL);
        if (url == null) {
            try {
                url = new URL(fileURL);
            }
            catch (MalformedURLException e) {
                throw new GrizzlyConfigException(e.getMessage());
            }
        }
        try {
            habitat = Utils.getHabitat(url.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return habitat;
    }

    public static Habitat getHabitat(InputStream inputStream) {
        try {
            Habitat habitat = Utils.getNewHabitat();
            ConfigParser parser = new ConfigParser(habitat);
            XMLInputFactory xif = XMLInputFactory.class.getClassLoader() == null ? XMLInputFactory.newFactory() : XMLInputFactory.newFactory(XMLInputFactory.class.getName(), XMLInputFactory.class.getClassLoader());
            DomDocument document = parser.parse(xif.createXMLStreamReader(inputStream));
            habitat.addComponent((Object)document);
            return habitat;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GrizzlyConfigException(e.getMessage(), e);
        }
    }

    public static Habitat getNewHabitat() {
        Enumeration<URL> resources;
        Holder<ClassLoader> holder = new Holder<ClassLoader>(){

            public ClassLoader get() {
                return this.getClass().getClassLoader();
            }
        };
        try {
            resources = Utils.class.getClassLoader().getResources("META-INF/inhabitants/default");
        }
        catch (IOException e) {
            throw new GrizzlyConfigException(e);
        }
        if (resources == null) {
            System.out.println("Cannot find any inhabitant file in the classpath");
            return null;
        }
        Habitat habitat = new Habitat();
        while (resources.hasMoreElements()) {
            InhabitantsScanner scanner;
            URL resource = resources.nextElement();
            try {
                scanner = new InhabitantsScanner(resource.openConnection().getInputStream(), habitatName);
            }
            catch (IOException e) {
                throw new GrizzlyConfigException(e);
            }
            InhabitantsParser inhabitantsParser = new InhabitantsParser(habitat);
            try {
                inhabitantsParser.parse((Iterable)scanner, (Holder)holder);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return habitat;
    }

    public static String composeThreadPoolName(NetworkListener networkListener) {
        return networkListener.getThreadPool() + '-' + networkListener.getPort();
    }

    public static <E> E newInstance(Habitat habitat, Class<E> clazz, String name, String realClassName) {
        return Utils.newInstance(habitat, clazz, name, realClassName, null, null);
    }

    public static <E> E newInstance(Habitat habitat, Class<E> clazz, String name, String realClassName, Class<?>[] argTypes, Object[] args) {
        boolean isInitialized = false;
        Object instance = habitat.getComponent(clazz, name);
        if (instance == null) {
            try {
                instance = argTypes == null || argTypes.length == 0 ? Utils.newInstance(realClassName) : Utils.newInstance(realClassName, argTypes, args);
                isInitialized = true;
            }
            catch (Exception ignored) {}
        } else {
            isInitialized = true;
        }
        if (!isInitialized) {
            LOGGER.log(Level.WARNING, "Instance could not be initialized. Class={0}, name={1}, realClassName={2}", new Object[]{clazz, name, realClassName});
            return null;
        }
        return (E)instance;
    }

    public static Object newInstance(String classname) throws Exception {
        return Utils.loadClass(classname).newInstance();
    }

    public static Object newInstance(String classname, Class<?>[] argTypes, Object[] args) throws Exception {
        Class clazz = Utils.loadClass(classname);
        Constructor c = clazz.getConstructor(argTypes);
        assert (c != null);
        return c.newInstance(args);
    }

    public static Class loadClass(String classname) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                clazz = cl.loadClass(classname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = Utils.class.getClassLoader().loadClass(classname);
        }
        return clazz;
    }

    public static boolean isDebugVM() {
        boolean debugMode = false;
        List<String> l = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String s : l) {
            if (!s.trim().startsWith("-Xrunjdwp:") && !s.contains("jdwp")) continue;
            debugMode = true;
            break;
        }
        return debugMode;
    }
}

