/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools.asadmin;

import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.main.itest.tools.asadmin.AsadminResult;
import org.glassfish.main.itest.tools.asadmin.AsadminResultMatcher;
import org.glassfish.main.itest.tools.asadmin.DetachedTerseAsadminResult;
import org.glassfish.main.itest.tools.asadmin.KeyAndValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class Asadmin {
    private static final Logger LOG = Logger.getLogger(Asadmin.class.getName());
    private static final int DEFAULT_TIMEOUT_MSEC = 30000;
    private static final Function<String, KeyAndValue<String>> KEYVAL_SPLITTER = s -> {
        int equalSignPos = s.indexOf(61);
        if (equalSignPos <= 0 || equalSignPos == s.length() - 1) {
            return null;
        }
        return new KeyAndValue<String>(s.substring(0, equalSignPos), s.substring(equalSignPos + 1, s.length()));
    };
    private final File asadmin;
    private final String adminUser;
    private final File adminPasswordFile;
    private final boolean terse;
    private final Map<String, String> environment = new HashMap<String, String>();
    private final Map<String, String> additionalPasswords = new HashMap<String, String>();

    public Asadmin(File asadmin, String adminUser, File adminPasswordFile) {
        this(asadmin, adminUser, adminPasswordFile, false);
    }

    public Asadmin(File asadmin, String adminUser, File adminPasswordFile, boolean terse) {
        this.asadmin = asadmin;
        this.adminUser = adminUser;
        this.adminPasswordFile = adminPasswordFile;
        this.terse = terse;
    }

    public Asadmin withEnv(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    public Asadmin withPassword(String name, String secretValue) {
        this.additionalPasswords.put(name, secretValue);
        return this;
    }

    public Asadmin resetPasswords() {
        this.additionalPasswords.clear();
        return this;
    }

    public String getCommandName() {
        return this.asadmin.getName();
    }

    public <T> KeyAndValue<T> getValue(String key, Function<String, T> transformer) {
        List<KeyAndValue<T>> result = this.get(key, transformer);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("The key is not concrete enough to get a single value: " + key);
        }
        return result.get(0);
    }

    public <T> List<KeyAndValue<T>> get(String key, Function<String, T> transformer) {
        AsadminResult result = this.exec("get", key);
        MatcherAssert.assertThat((Object)result, (Matcher)AsadminResultMatcher.asadminOK());
        return Arrays.stream(result.getStdOut().split(System.lineSeparator())).map(KEYVAL_SPLITTER).filter(Objects::nonNull).map(kv -> new KeyAndValue(kv.getKey(), transformer.apply((String)kv.getValue()))).collect(Collectors.toList());
    }

    public DetachedTerseAsadminResult execDetached(String ... args) {
        return (DetachedTerseAsadminResult)this.exec(30000, true, args);
    }

    public AsadminResult exec(String ... args) {
        return this.exec(30000, false, args);
    }

    public AsadminResult exec(int timeout, String ... args) {
        return this.exec(timeout, false, args);
    }

    private File getPasswordFile() {
        try {
            if (!this.additionalPasswords.isEmpty()) {
                Path tempPasswordFile = Files.createTempFile("pwd", "txt", new FileAttribute[0]);
                Files.copy(this.adminPasswordFile.toPath(), tempPasswordFile, StandardCopyOption.REPLACE_EXISTING);
                String additionalContent = this.additionalPasswords.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("\n"));
                Files.writeString(tempPasswordFile, (CharSequence)("\n" + additionalContent), StandardOpenOption.APPEND);
                return tempPasswordFile.toFile();
            }
            return this.adminPasswordFile;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create the temporary password file.", e);
        }
    }

    private AsadminResult exec(int timeout, boolean detachedAndTerse, String ... args) {
        int exitCode;
        List<String> parameters = Arrays.asList(args);
        LOG.log(Level.INFO, "exec(timeout={0}, detached={1}, args={2})", new Object[]{timeout, detachedAndTerse, parameters});
        ArrayList<Object> command = new ArrayList<Object>();
        command.add(this.asadmin.getAbsolutePath());
        command.add("--user");
        command.add(this.adminUser);
        command.add("--passwordfile");
        command.add(this.getPasswordFile().getAbsolutePath());
        if (detachedAndTerse) {
            command.add("--terse=true");
            command.add("--detach");
        } else {
            command.add("--terse=" + this.terse);
        }
        command.addAll(parameters);
        ProcessManager processManager = new ProcessManager(command);
        processManager.setTimeoutMsec(timeout);
        processManager.setEcho(false);
        for (Map.Entry<String, String> env : this.environment.entrySet()) {
            processManager.setEnvironment(env.getKey(), env.getValue());
        }
        if (System.getenv("AS_TRACE") == null && LOG.isLoggable(Level.FINEST)) {
            processManager.setEnvironment("AS_TRACE", "true");
        }
        processManager.setEnvironment("JAVA_HOME", System.getProperty("java.home"));
        processManager.setEnvironment("AS_JAVA", System.getProperty("java.home"));
        String asadminErrorMessage = "";
        try {
            exitCode = processManager.execute();
        }
        catch (ProcessManagerTimeoutException e) {
            asadminErrorMessage = e.getMessage();
            exitCode = 1;
        }
        catch (ProcessManagerException e) {
            LOG.log(Level.SEVERE, "The execution failed.", e);
            asadminErrorMessage = e.getMessage();
            exitCode = 1;
        }
        String stdErr = processManager.getStderr() + "\n" + asadminErrorMessage;
        AsadminResult result = detachedAndTerse ? new DetachedTerseAsadminResult(args[0], exitCode, processManager.getStdout(), stdErr) : new AsadminResult(args[0], exitCode, processManager.getStdout(), stdErr);
        if (!result.getStdOut().isEmpty()) {
            System.out.println(result.getStdOut());
        }
        if (!result.getStdErr().isEmpty()) {
            System.err.println(result.getStdErr());
        }
        return result;
    }
}

