/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools.asadmin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.main.itest.tools.GlassFishTestEnvironment;
import org.glassfish.main.itest.tools.asadmin.AsadminResult;
import org.glassfish.main.itest.tools.asadmin.AsadminResultMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class CollectLogFiles {
    private File fileWithLogs;

    public CollectLogFiles collect() throws IOException {
        AsadminResult result = GlassFishTestEnvironment.getAsadmin().exec("collect-log-files");
        MatcherAssert.assertThat((Object)result, AsadminResultMatcher.asadminOK());
        String path = StringUtils.substringBetween((String)result.getStdOut(), (String)"Created Zip file under ", (String)".\n");
        MatcherAssert.assertThat((String)("zip file path parsed from " + result.getStdOut()), (Object)path, (Matcher)CoreMatchers.notNullValue());
        this.fileWithLogs = new File(path);
        this.fileWithLogs.deleteOnExit();
        MatcherAssert.assertThat((Object)this.fileWithLogs.getName(), (Matcher)CoreMatchers.endsWith((String)".zip"));
        return this;
    }

    public List<String> getServerLogLines() throws IOException {
        return this.getLogLines("logs/server/server.log");
    }

    private List<String> getLogLines(String logFilePath) throws IOException {
        try (ZipFile zipFile = new ZipFile(this.fileWithLogs);){
            ArrayList<String> arrayList;
            ZipEntry entry = zipFile.getEntry(logFilePath);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));){
                ArrayList<String> lines = new ArrayList<String>();
                while (reader.ready()) {
                    lines.add(reader.readLine());
                }
                arrayList = lines;
            }
            return arrayList;
        }
    }
}

