/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools.asadmin;

public class AsadminResult {
    private final boolean error;
    private final String stdOut;
    private final String stdErr;
    private final String output;

    public AsadminResult(String commandName, int exitCode, String stdOut, String stdErr) {
        this.error = exitCode != 0 || AsadminResult.containsError(stdOut, String.format("Command %s failed.", commandName));
        this.stdOut = stdOut;
        this.stdErr = stdErr;
        this.output = (this.stdOut + " " + this.stdErr).strip();
    }

    public boolean isError() {
        return this.error;
    }

    public String getStdOut() {
        return this.stdOut;
    }

    public String getStdErr() {
        return this.stdErr;
    }

    public String getOutput() {
        return this.output;
    }

    public String toString() {
        return this.getOutput();
    }

    private static boolean containsError(String text, String ... invalidResults) {
        for (String result : invalidResults) {
            if (!text.contains(result)) continue;
            return true;
        }
        return false;
    }
}

