/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools.asadmin;

import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.itest.tools.asadmin.AsadminResult;
import org.glassfish.main.itest.tools.asadmin.AsadminResultMatcher;
import org.glassfish.main.itest.tools.asadmin.DetachedTerseAsadminResult;
import org.glassfish.main.itest.tools.asadmin.KeyAndValue;
import org.hamcrest.MatcherAssert;

public class Asadmin {
    private static final System.Logger LOG = System.getLogger(Asadmin.class.getName());
    private static final Function<String, KeyAndValue<String>> KEYVAL_SPLITTER = s -> {
        int equalSignPos = s.indexOf(61);
        if (equalSignPos <= 0 || equalSignPos == s.length() - 1) {
            return null;
        }
        return new KeyAndValue<String>(s.substring(0, equalSignPos), s.substring(equalSignPos + 1, s.length()));
    };
    private static final boolean IS_WINDOWS = System.getProperty("os.name").contains("windows");
    private static final String JAVA_HOME_VALUE = System.getProperty(GlassFishVariable.JAVA_HOME.getSystemPropertyName());
    private static final String JAVA_EXECUTABLE = JAVA_HOME_VALUE + File.separatorChar + "bin" + File.separatorChar + "java" + (IS_WINDOWS ? ".exe" : "");
    private final File asadmin;
    private final String adminUser;
    private final File adminPasswordFile;
    private final boolean terse;
    private final Map<String, String> environment = new HashMap<String, String>();
    private final Map<String, String> additionalPasswords = new HashMap<String, String>();

    public Asadmin(File asadmin, String adminUser, File adminPasswordFile) {
        this(asadmin, adminUser, adminPasswordFile, false);
    }

    public Asadmin(File asadmin, String adminUser, File adminPasswordFile, boolean terse) {
        this.asadmin = asadmin;
        this.adminUser = adminUser;
        this.adminPasswordFile = adminPasswordFile;
        this.terse = terse;
    }

    public Asadmin withEnv(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    public Asadmin withPassword(String name, String secretValue) {
        this.additionalPasswords.put(name, secretValue);
        return this;
    }

    public Asadmin resetPasswords() {
        this.additionalPasswords.clear();
        return this;
    }

    public String getCommandName() {
        return this.asadmin.getName();
    }

    public <T> KeyAndValue<T> getValue(String key, Function<String, T> transformer) {
        List<KeyAndValue<T>> result = this.get(key, transformer);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("The key is not concrete enough to get a single value: " + key);
        }
        return result.get(0);
    }

    public <T> List<KeyAndValue<T>> get(String key, Function<String, T> transformer) {
        AsadminResult result = this.exec("get", key);
        MatcherAssert.assertThat((Object)result, AsadminResultMatcher.asadminOK());
        return Arrays.stream(result.getStdOut().split("[\n\r]+")).map(KEYVAL_SPLITTER).filter(Objects::nonNull).map(kv -> new KeyAndValue(kv.getKey(), transformer.apply((String)kv.getValue()))).collect(Collectors.toList());
    }

    public DetachedTerseAsadminResult execDetached(String ... args) {
        return (DetachedTerseAsadminResult)this.exec(null, true, args);
    }

    public AsadminResult exec(String ... args) {
        return this.exec(null, false, args);
    }

    public AsadminResult exec(int timeout, String ... args) {
        return this.exec((Integer)timeout, false, args);
    }

    private File getPasswordFile() {
        if (!this.additionalPasswords.isEmpty()) {
            Objects.requireNonNull(this.adminPasswordFile, "The admin password file is not set.");
            try {
                Path tempPasswordFile = Files.createTempFile("pwd", "txt", new FileAttribute[0]);
                Files.copy(this.adminPasswordFile.toPath(), tempPasswordFile, StandardCopyOption.REPLACE_EXISTING);
                String additionalContent = this.additionalPasswords.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("\n"));
                Files.writeString(tempPasswordFile, (CharSequence)("\n" + additionalContent), StandardOpenOption.APPEND);
                return tempPasswordFile.toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not create the temporary password file.", e);
            }
        }
        return this.adminPasswordFile;
    }

    /*
     * WARNING - void declaration
     */
    private AsadminResult exec(Integer timeout, boolean detachedAndTerse, String ... args) {
        void var7_12;
        void var8_17;
        List<String> parameters = Arrays.asList(args);
        LOG.log(System.Logger.Level.INFO, "exec(timeout={0}, detached={1}, args={2})", timeout, detachedAndTerse, parameters);
        ArrayList<Object> command = new ArrayList<Object>();
        if (this.asadmin.getName().endsWith(".java")) {
            command.add(JAVA_EXECUTABLE);
            command.add("-Xms64m");
            command.add("-Xmx64m");
            command.add("-Xss256k");
            command.add("-XX:+UnlockExperimentalVMOptions");
            command.add("-XX:+UseEpsilonGC");
            command.add("-XX:-AlwaysPreTouch");
            command.add("-XX:TieredStopAtLevel=1");
            command.add("-XX:-UsePerfData");
            command.add("-Xlog:gc*=off");
            command.add("-Djava.awt.headless=true");
        }
        command.add(this.asadmin.getAbsolutePath());
        command.add("--user");
        command.add(this.adminUser);
        if (this.getPasswordFile() != null) {
            command.add("--passwordfile");
            command.add(this.getPasswordFile().getAbsolutePath());
        }
        if (detachedAndTerse) {
            command.add("--terse=true");
            command.add("--detach");
        } else {
            command.add("--terse=" + this.terse);
        }
        for (String string : parameters) {
            command.add(Asadmin.escape(string));
        }
        ProcessManager processManager = new ProcessManager(command);
        if (timeout != null) {
            processManager.setTimeout(timeout.intValue());
        }
        processManager.setEcho(false);
        if (System.getenv("AS_TRACE") == null && LOG.isLoggable(System.Logger.Level.TRACE)) {
            processManager.setEnvironment("AS_TRACE", "true");
        }
        for (Map.Entry<String, String> entry : this.environment.entrySet()) {
            processManager.setEnvironment(entry.getKey(), entry.getValue());
        }
        processManager.setEnvironment(GlassFishVariable.JAVA_HOME.getEnvName(), JAVA_HOME_VALUE);
        processManager.setEnvironment(GlassFishVariable.JAVA_ROOT.getEnvName(), JAVA_HOME_VALUE);
        String string = "";
        try {
            int n = processManager.execute();
        }
        catch (ProcessManagerTimeoutException e) {
            String string2 = e.getMessage();
            int n = 2;
        }
        catch (ProcessManagerException e) {
            LOG.log(System.Logger.Level.ERROR, "The execution failed.", (Throwable)e);
            String string3 = e.getMessage();
            boolean bl = true;
        }
        String stdOut = processManager.getStdout().strip();
        String stdErr = (processManager.getStderr() + "\n" + (String)var8_17).strip();
        if (!stdOut.isEmpty()) {
            LOG.log(System.Logger.Level.INFO, () -> "STDOUT: \n" + stdOut);
        }
        if (!stdErr.isEmpty()) {
            LOG.log(System.Logger.Level.INFO, () -> "STDERR: \n" + stdErr);
        }
        if (detachedAndTerse) {
            return new DetachedTerseAsadminResult(args[0], (int)var7_12, stdOut, stdErr);
        }
        return new AsadminResult(args[0], (int)var7_12, stdOut, stdErr);
    }

    private static final String escape(String input) {
        if (!IS_WINDOWS) {
            return input;
        }
        return "\"" + input + "\"";
    }
}

