/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools.asadmin;

import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.itest.tools.asadmin.AsadminResult;

public class StartServ {
    private static final Logger LOG = Logger.getLogger(StartServ.class.getName());
    private static final int DEFAULT_TIMEOUT_MSEC = 30000;
    private final File startServ;
    private final Map<String, String> environment = new HashMap<String, String>();
    private String textToWaitFor;

    public StartServ(File startServ) {
        this.startServ = startServ;
    }

    public StartServ withEnv(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    public StartServ withTextToWaitFor(String textToWaitFor) {
        this.textToWaitFor = textToWaitFor;
        return this;
    }

    public StartServ withNoTextToWaitFor() {
        this.textToWaitFor = null;
        return this;
    }

    public String getCommandName() {
        return this.startServ.getName();
    }

    public AsadminResult exec(String ... args) {
        return this.exec(30000, args);
    }

    public AsadminResult exec(int timeout, String ... args) {
        int exitCode;
        List<String> parameters = Arrays.asList(args);
        LOG.log(Level.INFO, "exec(script={0}, timeout={1}, args={2})", new Object[]{this.startServ.getName(), timeout, parameters});
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.startServ.getAbsolutePath());
        command.addAll(parameters);
        ProcessManager processManager = new ProcessManager(command);
        processManager.setTimeout(timeout, false);
        processManager.setEcho(false);
        processManager.setTextToWaitFor(this.textToWaitFor);
        for (Map.Entry<String, String> env : this.environment.entrySet()) {
            processManager.setEnvironment(env.getKey(), env.getValue());
        }
        if (System.getenv("AS_TRACE") == null && LOG.isLoggable(Level.FINEST)) {
            processManager.setEnvironment("AS_TRACE", "true");
        }
        processManager.setEnvironment(GlassFishVariable.JAVA_HOME.getEnvName(), System.getProperty(GlassFishVariable.JAVA_HOME.getSystemPropertyName()));
        processManager.setEnvironment(GlassFishVariable.JAVA_ROOT.getEnvName(), System.getProperty(GlassFishVariable.JAVA_HOME.getSystemPropertyName()));
        String asadminErrorMessage = "";
        try {
            exitCode = processManager.execute();
        }
        catch (ProcessManagerTimeoutException e) {
            asadminErrorMessage = e.getMessage();
            exitCode = 1;
        }
        catch (ProcessManagerException e) {
            LOG.log(Level.SEVERE, "The execution failed.", e);
            asadminErrorMessage = e.getMessage();
            exitCode = 1;
        }
        String stdErr = processManager.getStderr() + "\n" + asadminErrorMessage;
        AsadminResult result = new AsadminResult(this.getCommandName(), exitCode, processManager.getStdout(), stdErr);
        if (!result.getStdOut().isEmpty()) {
            System.out.println(result.getStdOut());
        }
        if (!result.getStdErr().isEmpty()) {
            System.err.println(result.getStdErr());
        }
        return result;
    }

    public String toString() {
        return this.startServ.toString();
    }
}

