/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools;

import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JarSigner {
    private static final System.Logger LOG = System.getLogger(JarSigner.class.getName());
    private final File jarsigner;

    public JarSigner(File jarsigner) {
        this.jarsigner = jarsigner;
    }

    public void exec(String ... args) {
        int exitCode;
        List<String> parameters = Arrays.asList(args);
        LOG.log(System.Logger.Level.INFO, "exec(args={0})", parameters);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.jarsigner.getAbsolutePath());
        command.addAll(parameters);
        ProcessManager processManager = new ProcessManager(command);
        processManager.setTimeoutMsec(60000);
        processManager.setEcho(true);
        String errorMessage = "";
        try {
            exitCode = processManager.execute();
        }
        catch (ProcessManagerTimeoutException e) {
            errorMessage = e.getMessage();
            exitCode = 1;
        }
        catch (ProcessManagerException e) {
            LOG.log(System.Logger.Level.ERROR, "The execution failed.", (Throwable)e);
            errorMessage = e.getMessage();
            exitCode = 1;
        }
        String stdErr = processManager.getStderr() + "\n" + errorMessage;
        if (!processManager.getStdout().isEmpty()) {
            System.out.println(processManager.getStdout());
        }
        if (!processManager.getStderr().isEmpty()) {
            System.err.println(processManager.getStderr());
        }
        if (exitCode != 0) {
            throw new RuntimeException(stdErr);
        }
    }
}

