/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class HttpClient10 {
    private final URL url;
    private final String user;
    private final String password;

    public HttpClient10(URL url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public HttpResponse send(String method, String content) throws Exception {
        try (Socket socket = new Socket(this.url.getHost(), this.url.getPort());){
            InputStream inputStream = socket.getInputStream();
            socket.setSoLinger(true, 1000);
            PrintWriter outputWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            outputWriter.println(method + " " + this.url.getPath() + " HTTP/1.0");
            outputWriter.println("Host: " + this.url.getHost() + ":" + this.url.getPort());
            if (content != null) {
                outputWriter.println("Content-Length: " + content.length());
            }
            if (this.user != null && this.password != null) {
                String basicAuth = Base64.getEncoder().encodeToString((this.user + ":" + this.password).getBytes(StandardCharsets.UTF_8));
                outputWriter.println("Authorization: Basic " + basicAuth);
            }
            outputWriter.println("");
            if (content != null) {
                outputWriter.print(content);
            }
            outputWriter.flush();
            HttpResponse httpResponse = HttpResponse.parse(inputStream);
            return httpResponse;
        }
    }

    public static class HttpResponse {
        public final String responseLine;
        public final Map<String, String> headers;
        public final String body;

        private HttpResponse(String responseLine, Map<String, String> headers, String body) {
            this.responseLine = responseLine;
            this.headers = headers;
            this.body = body;
        }

        private static HttpResponse parse(InputStream inputStream) throws IOException {
            String responseLine = HttpResponse.parseResponseLine(inputStream);
            Map<String, String> headers = HttpResponse.parseHeaders(inputStream);
            String body = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8).trim();
            return new HttpResponse(responseLine, headers, body);
        }

        private static Map<String, String> parseHeaders(InputStream is) throws IOException {
            String line;
            HashMap<String, String> headers = new HashMap<String, String>();
            while ((line = HttpResponse.parseResponseLine(is)) != null && !line.isEmpty()) {
                String[] header = HttpResponse.parseHeader(line);
                headers.put(header[0], header[1]);
            }
            return headers;
        }

        private static String[] parseHeader(String line) {
            int colon = line.indexOf(58);
            if (colon < 0) {
                throw new IllegalStateException("Invalid header: " + line);
            }
            String name = line.substring(0, colon).trim();
            String value = line.substring(colon + 1).trim();
            return new String[]{name, value};
        }

        private static String parseResponseLine(InputStream input) throws IOException {
            int ch;
            StringBuilder sb = new StringBuilder();
            while ((ch = input.read()) >= 0 && ch != 10) {
                sb.append((char)ch);
            }
            int n = sb.length();
            if (n > 0 && sb.charAt(n - 1) == '\r') {
                sb.setLength(n - 1);
            }
            return sb.toString();
        }
    }
}

