/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.cli;

import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.api.ActionReport;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="monitoring-config")
public class MonitoringConfig {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MonitoringConfig.class);
    private static AtomicBoolean valueUpdated = new AtomicBoolean(false);

    static void setMonitoringEnabled(MonitoringService ms, final String enabled, ActionReport report) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                    param.setMonitoringEnabled(enabled);
                    return param;
                }
            }, (ConfigBeanProxy)ms);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("disable.monitoring.exception", "Encountered exception while setting monitoring-enabled to false {0}", new Object[]{tfe.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    static void setMBeanEnabled(MonitoringService ms, final String enabled, ActionReport report) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                    param.setMbeanEnabled(enabled);
                    return param;
                }
            }, (ConfigBeanProxy)ms);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("disable.monitoring.exception", "Encountered exception while setting mbean-enabled to false {0}", new Object[]{tfe.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    static void setDTraceEnabled(MonitoringService ms, final String enabled, ActionReport report) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                    param.setDtraceEnabled(enabled);
                    return param;
                }
            }, (ConfigBeanProxy)ms);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("disable.monitoring.exception", "Encountered exception while setting dtrace-enabled to false {0}", new Object[]{tfe.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setMonitoringLevel(MonitoringService ms, final String moduleName, final String level, ActionReport report) {
        ModuleMonitoringLevels mmls = ms.getModuleMonitoringLevels();
        AtomicBoolean atomicBoolean = valueUpdated;
        synchronized (atomicBoolean) {
            valueUpdated.set(true);
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ModuleMonitoringLevels>(){

                    public Object run(ModuleMonitoringLevels param) throws PropertyVetoException, TransactionFailure {
                        if (moduleName.equals("connector-connection-pool")) {
                            param.setConnectorConnectionPool(level);
                        } else if (moduleName.equals("connector-service")) {
                            param.setConnectorService(level);
                        } else if (moduleName.equals("ejb-container")) {
                            param.setEjbContainer(level);
                        } else if (moduleName.equals("http-service")) {
                            param.setHttpService(level);
                        } else if (moduleName.equals("jdbc-connection-pool")) {
                            param.setJdbcConnectionPool(level);
                        } else if (moduleName.equals("jms-service")) {
                            param.setJmsService(level);
                        } else if (moduleName.equals("jvm")) {
                            param.setJvm(level);
                        } else if (moduleName.equals("orb")) {
                            param.setOrb(level);
                        } else if (moduleName.equals("thread-pool")) {
                            param.setThreadPool(level);
                        } else if (moduleName.equals("transaction-service")) {
                            param.setTransactionService(level);
                        } else if (moduleName.equals("web-container")) {
                            param.setWebContainer(level);
                        } else if (moduleName.equals("security")) {
                            param.setSecurity(level);
                        } else if (moduleName.equals("web-services-container")) {
                            param.setWebServicesContainer(level);
                        } else if (moduleName.equals("jpa")) {
                            param.setJpa(level);
                        } else if (moduleName.equals("jersey")) {
                            param.setJersey(level);
                        } else if (moduleName.equals("deployment")) {
                            param.setDeployment(level);
                        } else {
                            valueUpdated.set(false);
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)mmls);
            }
            catch (TransactionFailure tfe) {
                report.setMessage(localStrings.getLocalString("disable.monitoring.level", "Encountered exception {0} while setting monitoring level to OFF for {1}", new Object[]{tfe.getMessage(), moduleName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            if (!valueUpdated.get()) {
                MonitoringConfig.setContainerMonitoringLevel(ms, moduleName, level, report);
            }
        }
    }

    static void setMonitoringLevelX(MonitoringService ms, final String moduleName, final String level, ActionReport report) {
        ModuleMonitoringLevels mmls = ms.getModuleMonitoringLevels();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ModuleMonitoringLevels>(){

                public Object run(ModuleMonitoringLevels param) throws PropertyVetoException, TransactionFailure {
                    Dom dom = Dom.unwrap((ConfigBeanProxy)param);
                    String currentVal = dom.attribute(moduleName);
                    if (currentVal == null) {
                        valueUpdated.set(false);
                        return null;
                    }
                    dom.attribute(moduleName, level);
                    return param;
                }
            }, (ConfigBeanProxy)mmls);
        }
        catch (TransactionFailure tfe) {
            valueUpdated.set(false);
            report.setMessage(localStrings.getLocalString("disable.monitoring.level", "Encountered exception {0} while setting monitoring level to OFF for {1}", new Object[]{tfe.getMessage(), moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (!valueUpdated.get()) {
            MonitoringConfig.setContainerMonitoringLevel(ms, moduleName, level, report);
        }
    }

    static boolean setContainerMonitoringLevel(MonitoringService ms, String moduleName, final String level, ActionReport report) {
        ContainerMonitoring cm = ms.getContainerMonitoring(moduleName);
        if (cm == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(localStrings.getLocalString("invalid.module", "Invalid module name {0}", new Object[]{moduleName}));
            return false;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ContainerMonitoring>(){

                public Object run(ContainerMonitoring param) throws PropertyVetoException, TransactionFailure {
                    param.setLevel(level);
                    return param;
                }
            }, (ConfigBeanProxy)cm);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("disable.monitoring.level", "Encountered exception {0} while setting monitoring level to OFF for {1}", new Object[]{tfe.getMessage(), moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return true;
    }
}

