/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.jwt.jwt;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.security.enterprise.CallerPrincipal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JsonWebTokenImpl
extends CallerPrincipal
implements JsonWebToken {
    private final Map<String, JsonValue> claims;

    public JsonWebTokenImpl(String callerName, Map<String, JsonValue> claims) {
        super(callerName);
        this.claims = claims;
    }

    public Map<String, JsonValue> getClaims() {
        return this.claims;
    }

    @Override
    public <T> T getClaim(String claimName) {
        JsonValue claimValue = this.claims.get(claimName);
        if (claimValue == null) {
            return null;
        }
        try {
            Claims claim = Claims.valueOf(claimName);
            if (claim.getType().equals(Long.class)) {
                return (T)Long.valueOf(((JsonNumber)claimValue).longValue());
            }
            if (claim.getType().equals(Set.class)) {
                if (claimValue instanceof JsonString) {
                    return (T)Collections.singleton(((JsonString)claimValue).getString());
                }
                return (T)JsonWebTokenImpl.asStringSet((JsonArray)claimValue);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (claimValue instanceof JsonString) {
            return (T)((JsonString)claimValue).getString();
        }
        return (T)this.claims.get(claimName);
    }

    @Override
    public Set<String> getClaimNames() {
        if (this.claims.isEmpty()) {
            return null;
        }
        return this.claims.keySet();
    }

    private static Set<String> asStringSet(JsonArray jsonArray) {
        return new HashSet<JsonString>(jsonArray.getValuesAs(JsonString.class)).stream().map(t -> t.getString()).collect(Collectors.toSet());
    }
}

