/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.jwt.jaxrs;

import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import org.omnifaces.jwt.jaxrs.DenyAllRequestFilter;
import org.omnifaces.jwt.jaxrs.RolesAllowedRequestFilter;

@Provider
public class RolesAllowedDynamicFeature
implements DynamicFeature {
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    @Override
    public void configure(ResourceInfo resourceInfo, FeatureContext configuration) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod.isAnnotationPresent(DenyAll.class)) {
            configuration.register(new DenyAllRequestFilter());
            return;
        }
        if (resourceMethod.isAnnotationPresent(PermitAll.class)) {
            configuration.register(new RolesAllowedRequestFilter(this.request, this.response));
            return;
        }
        RolesAllowed rolesAllowed = resourceMethod.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            configuration.register(new RolesAllowedRequestFilter(this.request, this.response, rolesAllowed.value()));
            return;
        }
        rolesAllowed = resourceInfo.getResourceClass().getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            configuration.register(new RolesAllowedRequestFilter(this.request, this.response, rolesAllowed.value()));
        }
    }
}

