/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.jwt.cdi;

import jakarta.annotation.security.RolesAllowed;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.ProcessSessionBean;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.auth.LoginConfig;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.omnifaces.jwt.cdi.CdiInitEventHandler;
import org.omnifaces.jwt.cdi.InjectionPointGenerator;

public class CdiExtension
implements Extension {
    private boolean addJWTAuthenticationMechanism;
    private final Set<String> roles = new HashSet<String>();

    public void register(@Observes BeforeBeanDiscovery beforeBean, BeanManager beanManager) {
        beforeBean.addAnnotatedType(beanManager.createAnnotatedType(InjectionPointGenerator.class), "JWT InjectionPointGenerator ");
    }

    public <T> void findLoginConfigAnnotation(@Observes ProcessBean<T> eventIn, BeanManager beanManager) {
        ProcessBean<T> event = eventIn;
        LoginConfig loginConfig = event.getAnnotated().getAnnotation(LoginConfig.class);
        if (loginConfig != null && loginConfig.authMethod().equals("MP-JWT")) {
            this.addJWTAuthenticationMechanism = true;
        }
    }

    public <T> void findRoles(@Observes ProcessManagedBean<T> eventIn, BeanManager beanManager) {
        ProcessManagedBean<T> event = eventIn;
        if (event instanceof ProcessSessionBean) {
            return;
        }
        ArrayList<AnnotatedMethod<T>> annotatedElements = new ArrayList<AnnotatedMethod<T>>(event.getAnnotatedBeanClass().getMethods());
        annotatedElements.add((AnnotatedMethod<T>)((Object)event.getAnnotatedBeanClass()));
        for (Annotated annotated : annotatedElements) {
            RolesAllowed rolesAllowed = annotated.getAnnotation(RolesAllowed.class);
            if (rolesAllowed == null) continue;
            this.roles.addAll(Arrays.asList(rolesAllowed.value()));
        }
    }

    public <T> void checkInjectIntoRightScope(@Observes ProcessInjectionTarget<T> eventIn, BeanManager beanManager) {
        ProcessInjectionTarget<T> event = eventIn;
        for (InjectionPoint injectionPoint : event.getInjectionTarget().getInjectionPoints()) {
            Class<Annotation> scope;
            Claim claim = CdiExtension.hasClaim(injectionPoint);
            if (claim == null) continue;
            Bean<?> bean = injectionPoint.getBean();
            Class<Annotation> clazz = scope = bean != null ? injectionPoint.getBean().getScope() : null;
            if (scope != null && scope.equals(SessionScoped.class)) {
                throw new DeploymentException("Can't inject using qualifier " + String.valueOf(Claim.class) + " in a target with scope " + String.valueOf(scope));
            }
            if (claim.value().equals("") || claim.standard() == Claims.UNKNOWN || claim.value().equals(claim.standard().name())) continue;
            throw new DeploymentException("Claim value " + claim.value() + " should be equal to claim standard " + claim.standard().name() + " or one of those should be left at their default value");
        }
    }

    public void installMechanismIfNeeded(@Observes AfterBeanDiscovery eventIn, BeanManager beanManager) {
        AfterBeanDiscovery afterBeanDiscovery = eventIn;
        if (this.addJWTAuthenticationMechanism) {
            this.validateConfigValue();
            CdiInitEventHandler.installAuthenticationMechanism(afterBeanDiscovery);
        }
    }

    private void validateConfigValue() {
        Config config = ConfigProvider.getConfig();
        if (config.getOptionalValue("mp.jwt.verify.publickey", String.class).isPresent() && config.getOptionalValue("mp.jwt.verify.publickey.location", String.class).isPresent()) {
            throw new DeploymentException("Both properties mp.jwt.verify.publickey and mp.jwt.verify.publickey.location must not be defined");
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean isAddJWTAuthenticationMechanism() {
        return this.addJWTAuthenticationMechanism;
    }

    private static Claim hasClaim(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(Claim.class)) continue;
            return (Claim)qualifier;
        }
        return null;
    }
}

