/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.resolution.AbstractAssignabilityRules;
import org.jboss.weld.resolution.AssignabilityRules;
import org.jboss.weld.resolution.CovariantTypes;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

public class EventTypeAssignabilityRules
extends AbstractAssignabilityRules {
    private static final AssignabilityRules INSTANCE = new EventTypeAssignabilityRules();

    public static AssignabilityRules instance() {
        return INSTANCE;
    }

    private EventTypeAssignabilityRules() {
    }

    @Override
    public boolean matches(Type observedType, Type eventType) {
        return this.matchesNoBoxing(Types.boxedType(observedType), Types.boxedType(eventType));
    }

    public boolean matchesNoBoxing(Type observedType, Type eventType) {
        if (Types.isArray(observedType) && Types.isArray(eventType)) {
            Type observedComponentType = Types.getArrayComponentType(observedType);
            for (Type type2 : new HierarchyDiscovery(Types.getArrayComponentType(eventType)).getTypeClosure()) {
                if (!this.matchesNoBoxing(observedComponentType, type2)) continue;
                return true;
            }
            return false;
        }
        if (observedType instanceof TypeVariable) {
            return this.matches((TypeVariable)observedType, eventType);
        }
        if (observedType instanceof Class && eventType instanceof ParameterizedType) {
            return observedType.equals(Reflections.getRawType(eventType));
        }
        if (observedType instanceof ParameterizedType && eventType instanceof ParameterizedType) {
            return this.matches((ParameterizedType)observedType, (ParameterizedType)eventType);
        }
        if (observedType instanceof Class && eventType instanceof Class) {
            return observedType.equals(eventType);
        }
        return false;
    }

    private boolean matches(TypeVariable<?> observedType, Type eventType) {
        for (Type bound : EventTypeAssignabilityRules.getUppermostTypeVariableBounds(observedType)) {
            if (CovariantTypes.isAssignableFrom(bound, eventType)) continue;
            return false;
        }
        return true;
    }

    private boolean matches(ParameterizedType observedType, ParameterizedType eventType) {
        if (!observedType.getRawType().equals(eventType.getRawType())) {
            return false;
        }
        if (observedType.getActualTypeArguments().length != eventType.getActualTypeArguments().length) {
            throw ReflectionLogger.LOG.invalidTypeArgumentCombination(observedType, eventType);
        }
        for (int i = 0; i < observedType.getActualTypeArguments().length; ++i) {
            if (this.parametersMatch(observedType.getActualTypeArguments()[i], eventType.getActualTypeArguments()[i])) continue;
            return false;
        }
        return true;
    }

    private boolean parametersMatch(Type observedParameter, Type eventParameter) {
        if (Types.isActualType(observedParameter) && Types.isActualType(eventParameter)) {
            return this.matches(observedParameter, eventParameter);
        }
        if (observedParameter instanceof WildcardType && eventParameter instanceof WildcardType) {
            return CovariantTypes.isAssignableFrom(observedParameter, eventParameter);
        }
        if (observedParameter instanceof WildcardType) {
            return this.parametersMatch((WildcardType)observedParameter, eventParameter);
        }
        if (observedParameter instanceof TypeVariable) {
            return this.parametersMatch((TypeVariable)observedParameter, eventParameter);
        }
        return false;
    }

    private boolean parametersMatch(TypeVariable<?> observedParameter, Type eventParameter) {
        for (Type bound : EventTypeAssignabilityRules.getUppermostTypeVariableBounds(observedParameter)) {
            if (CovariantTypes.isAssignableFrom(bound, eventParameter)) continue;
            return false;
        }
        return true;
    }

    private boolean parametersMatch(WildcardType observedParameter, Type eventParameter) {
        return this.lowerBoundsOfWildcardMatch(eventParameter, observedParameter) && this.upperBoundsOfWildcardMatch(observedParameter, eventParameter);
    }
}

