/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import org.jboss.weld.bean.builtin.AbstractStaticallyDecorableBuiltInBean;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.web.logging.ServletLogger;
import org.jboss.weld.module.web.servlet.SessionHolder;

public class HttpSessionBean
extends AbstractStaticallyDecorableBuiltInBean<HttpSession> {
    public HttpSessionBean(BeanManagerImpl manager) {
        super(manager, HttpSession.class);
    }

    @Override
    protected HttpSession newInstance(InjectionPoint ip, CreationalContext<HttpSession> creationalContext) {
        return new SerializableProxy();
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    private static class SerializableProxy
    implements HttpSession,
    Serializable {
        private static final long serialVersionUID = -617233973786462227L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="False positive from FindBugs - field is set lazily.")
        private volatile transient HttpSession session = this.obtainHttpSession();

        private SerializableProxy() {
        }

        @Override
        public long getCreationTime() {
            return this.session().getCreationTime();
        }

        @Override
        public String getId() {
            return this.session().getId();
        }

        @Override
        public long getLastAccessedTime() {
            return this.session().getLastAccessedTime();
        }

        @Override
        public ServletContext getServletContext() {
            return this.session().getServletContext();
        }

        @Override
        public void setMaxInactiveInterval(int interval) {
            this.session().setMaxInactiveInterval(interval);
        }

        @Override
        public int getMaxInactiveInterval() {
            return this.session().getMaxInactiveInterval();
        }

        @Override
        public Object getAttribute(String name) {
            return this.session().getAttribute(name);
        }

        @Override
        public Enumeration<String> getAttributeNames() {
            return this.session().getAttributeNames();
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.session().setAttribute(name, value);
        }

        @Override
        public void removeAttribute(String name) {
            this.session().removeAttribute(name);
        }

        @Override
        public void invalidate() {
            this.session().invalidate();
        }

        @Override
        public boolean isNew() {
            return this.session().isNew();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HttpSession session() {
            if (this.session == null) {
                SerializableProxy serializableProxy = this;
                synchronized (serializableProxy) {
                    if (this.session == null) {
                        this.session = this.obtainHttpSession();
                    }
                }
            }
            return this.session;
        }

        private HttpSession obtainHttpSession() {
            HttpSession session = SessionHolder.getSessionIfExists();
            if (session == null) {
                throw ServletLogger.LOG.cannotInjectObjectOutsideOfServletRequest(HttpSession.class.getSimpleName(), null);
            }
            return session;
        }
    }
}

