/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.ejb;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.reflect.Constructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.proxy.EnterpriseTargetBeanInstance;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.ejb.spi.helpers.ForwardingEjbDescriptor;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.ejb.EnterpriseBeanProxyMethodHandler;
import org.jboss.weld.module.ejb.EnterpriseProxyFactory;
import org.jboss.weld.module.ejb.InjectionPointPropagatingEnterpriseTargetBeanInstance;
import org.jboss.weld.module.ejb.SessionBeanImpl;

class SessionBeanProxyInstantiator<T>
implements Instantiator<T> {
    private final Class<T> proxyClass;
    private final SessionBeanImpl<T> bean;

    SessionBeanProxyInstantiator(EnhancedAnnotatedType<T> type2, SessionBeanImpl<T> bean) {
        this.bean = bean;
        this.proxyClass = new EnterpriseProxyFactory(type2.getJavaClass(), bean).getProxyClass();
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        try {
            T instance = this.proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!this.bean.getScope().equals(Dependent.class)) {
                ctx.push(instance);
            }
            ProxyFactory.setBeanInstance(this.bean.getBeanManager().getContextId(), instance, this.createEnterpriseTargetBeanInstance(), this.bean);
            return instance;
        }
        catch (Exception e) {
            throw BeanLogger.LOG.sessionBeanProxyInstantiationFailed(this.bean, this.proxyClass, e);
        }
    }

    protected EnterpriseTargetBeanInstance createEnterpriseTargetBeanInstance() {
        if (((ForwardingEjbDescriptor)this.bean.getEjbDescriptor()).isStateless() || ((ForwardingEjbDescriptor)this.bean.getEjbDescriptor()).isSingleton()) {
            return new InjectionPointPropagatingEnterpriseTargetBeanInstance(this.bean.getBeanClass(), new EnterpriseBeanProxyMethodHandler<T>(this.bean), this.bean.getBeanManager());
        }
        return new EnterpriseTargetBeanInstance(this.bean.getBeanClass(), new EnterpriseBeanProxyMethodHandler<T>(this.bean));
    }

    @Override
    public boolean hasInterceptorSupport() {
        return false;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return false;
    }

    public SessionBean<T> getBean() {
        return this.bean;
    }

    @Override
    public Constructor<T> getConstructor() {
        return null;
    }
}

