/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.invokable;

import java.lang.reflect.Method;
import org.jboss.weld.logging.InvokerLogger;

public class InvokerValidationUtils {
    private InvokerValidationUtils() {
    }

    static void instanceHasType(Method invokerMethod, Class<?> type2, Object instance) {
        if (instance != null && !type2.isInstance(instance)) {
            throw InvokerLogger.LOG.wrongInstanceType(invokerMethod, instance.getClass(), type2);
        }
    }

    static void instanceNotNull(Method invokerMethod, Object instance) {
        if (instance == null) {
            throw InvokerLogger.LOG.nullInstance(invokerMethod);
        }
    }

    static void argumentsNotNull(Method invokerMethod, Class<?>[] expectedTypes, Object[] args) {
        if (invokerMethod.getParameterCount() == 0) {
            return;
        }
        if (args == null) {
            throw InvokerLogger.LOG.nullArgumentArray(invokerMethod);
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            Class<?> expectedType = expectedTypes[i];
            Object arg = args[i];
            if (expectedType == null || arg != null || !expectedType.isPrimitive()) continue;
            throw InvokerLogger.LOG.nullPrimitiveArgument(invokerMethod, i + 1);
        }
    }

    static void argCountAtLeast(Method invokerMethod, int requiredArgs, Object[] args) {
        int actualArgs;
        int n = actualArgs = args == null ? 0 : args.length;
        if (actualArgs < requiredArgs) {
            throw InvokerLogger.LOG.notEnoughArguments(invokerMethod, requiredArgs, actualArgs);
        }
    }

    static void argumentsHaveCorrectType(Method invokerMethod, Class<?>[] expectedTypes, Object[] args) {
        if (args == null) {
            throw InvokerLogger.LOG.nullArgumentArray(invokerMethod);
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            Class<?> expectedType = expectedTypes[i];
            Object arg = args[i];
            if (expectedType == null) continue;
            int pos = i + 1;
            if (expectedType.isPrimitive()) {
                if (arg == null) {
                    throw InvokerLogger.LOG.nullPrimitiveArgument(invokerMethod, pos);
                }
                if (InvokerValidationUtils.primitiveConversionPermitted(expectedType, arg.getClass())) continue;
                throw InvokerLogger.LOG.wrongArgumentType(invokerMethod, pos, arg.getClass(), expectedType);
            }
            if (arg == null || expectedType.isInstance(arg)) continue;
            throw InvokerLogger.LOG.wrongArgumentType(invokerMethod, pos, arg.getClass(), expectedType);
        }
    }

    private static boolean primitiveConversionPermitted(Class<?> primitive, Class<? extends Object> actual) {
        if (primitive == Integer.TYPE) {
            return actual == Integer.class || actual == Character.class || actual == Short.class || actual == Byte.class;
        }
        if (primitive == Long.TYPE) {
            return actual == Long.class || actual == Integer.class || actual == Character.class || actual == Short.class || actual == Byte.class;
        }
        if (primitive == Boolean.TYPE) {
            return actual == Boolean.class;
        }
        if (primitive == Double.TYPE) {
            return actual == Double.class || actual == Float.class || actual == Long.class || actual == Integer.class || actual == Character.class || actual == Short.class || actual == Byte.class;
        }
        if (primitive == Float.TYPE) {
            return actual == Float.class || actual == Long.class || actual == Integer.class || actual == Character.class || actual == Short.class || actual == Byte.class;
        }
        if (primitive == Short.TYPE) {
            return actual == Short.class || actual == Byte.class;
        }
        if (primitive == Character.TYPE) {
            return actual == Character.class;
        }
        if (primitive == Byte.TYPE) {
            return actual == Byte.class;
        }
        throw new RuntimeException("Unhandled primitive type: " + String.valueOf(primitive));
    }
}

