/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.jboss.weld.bean.builtin.AbstractDecorableBuiltInBean;
import org.jboss.weld.bean.builtin.DynamicLookupInjectionPoint;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.EmptyInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class AbstractFacadeBean<T>
extends AbstractDecorableBuiltInBean<T> {
    private Class<T> proxyClass;

    protected AbstractFacadeBean(BeanManagerImpl manager, Class<T> type2) {
        super(manager, type2);
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        super.destroy(instance, creationalContext);
        creationalContext.release();
    }

    @Override
    protected Class<T> getProxyClass() {
        return this.proxyClass;
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        this.proxyClass = new ProxyFactory(this.getBeanManager().getContextId(), this.getType(), this.getTypes(), this).getProxyClass();
    }

    @Override
    protected List<Decorator<?>> getDecorators(InjectionPoint ip) {
        return this.beanManager.resolveDecorators(Collections.singleton(ip.getType()), this.getQualifiers());
    }

    @Override
    protected InjectionPoint getInjectionPoint(CurrentInjectionPoint cip) {
        InjectionPoint ip = super.getInjectionPoint(cip);
        if (ip == null) {
            ip = new DynamicLookupInjectionPoint(EmptyInjectionPoint.INSTANCE, this.getDefaultType(), Collections.emptySet());
        }
        return ip;
    }

    protected abstract Type getDefaultType();
}

