/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.contexts.WeldCreationalContext;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.EmptyInjectionPoint;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public abstract class AbstractBuiltInMetadataBean<T>
extends AbstractBuiltInBean<T> {
    private final CurrentInjectionPoint cip;

    public AbstractBuiltInMetadataBean(BeanIdentifier identifier, Class<T> type2, BeanManagerImpl beanManager) {
        super(identifier, beanManager, type2);
        this.cip = beanManager.getServices().get(CurrentInjectionPoint.class);
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        InjectionPoint ip = (InjectionPoint)this.cip.peek();
        if (ip == null || EmptyInjectionPoint.INSTANCE.equals(ip)) {
            throw BeanLogger.LOG.dynamicLookupOfBuiltInNotAllowed(this.toString());
        }
        return this.newInstance(ip, creationalContext);
    }

    protected abstract T newInstance(InjectionPoint var1, CreationalContext<T> var2);

    protected WeldCreationalContext<?> getParentCreationalContext(CreationalContext<?> ctx) {
        WeldCreationalContext<?> parentContext;
        if (ctx instanceof WeldCreationalContext && (parentContext = ((WeldCreationalContext)ctx).getParentCreationalContext()) != null) {
            return parentContext;
        }
        throw BeanLogger.LOG.unableToDetermineParentCreationalContext(ctx);
    }

    @Override
    public String toString() {
        return "Implicit Bean [" + this.getType().getName() + "] with qualifiers [@Default]";
    }
}

