/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.attributes;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.util.Bindings;

public class ExternalBeanAttributesFactory {
    private ExternalBeanAttributesFactory() {
    }

    public static <T> BeanAttributes<T> of(BeanAttributes<T> source, BeanManager manager) {
        ExternalBeanAttributesFactory.validateBeanAttributes(source, manager);
        ImmutableBeanAttributes attributes = new ImmutableBeanAttributes(ExternalBeanAttributesFactory.defensiveCopy(source.getStereotypes()), source.isAlternative(), source.getName(), ExternalBeanAttributesFactory.defensiveCopy(source.getQualifiers()), ExternalBeanAttributesFactory.defensiveCopy(source.getTypes()), source.getScope());
        return attributes;
    }

    private static <T> Set<T> defensiveCopy(Set<T> set) {
        return new HashSet<T>(set);
    }

    public static void validateBeanAttributes(BeanAttributes<?> attributes, BeanManager manager) {
        ExternalBeanAttributesFactory.validateStereotypes(attributes, manager);
        ExternalBeanAttributesFactory.validateQualifiers(attributes, manager);
        ExternalBeanAttributesFactory.validateTypes(attributes, manager);
        ExternalBeanAttributesFactory.validateScope(attributes, manager);
    }

    public static void validateStereotypes(BeanAttributes<?> attributes, BeanManager manager) {
        if (attributes.getStereotypes() == null) {
            throw MetadataLogger.LOG.stereotypesNull(attributes);
        }
        for (Class<Annotation> annotation : attributes.getStereotypes()) {
            if (manager.isStereotype(annotation)) continue;
            throw MetadataLogger.LOG.notAStereotype(annotation, attributes);
        }
    }

    public static void validateQualifiers(BeanAttributes<?> attributes, BeanManager manager) {
        Set<Annotation> qualifiers = attributes.getQualifiers();
        Bindings.validateQualifiers(qualifiers, manager, attributes, "BeanAttributes.getQualifiers");
    }

    public static void validateTypes(BeanAttributes<?> attributes, BeanManager manager) {
        if (attributes.getTypes() == null) {
            throw MetadataLogger.LOG.typesNull(attributes);
        }
        if (attributes.getTypes().isEmpty()) {
            throw MetadataLogger.LOG.typesEmpty(attributes);
        }
        for (Type type2 : attributes.getTypes()) {
            ExternalBeanAttributesFactory.validateBeanType(type2, attributes);
        }
    }

    private static void validateBeanType(Type type2, BeanAttributes<?> attributes) {
        ExternalBeanAttributesFactory.checkBeanTypeNotATypeVariable(type2, type2, attributes);
        ExternalBeanAttributesFactory.checkBeanTypeForWildcardsAndTypeVariables(type2, type2, attributes);
    }

    private static void checkBeanTypeNotATypeVariable(Type beanType, Type type2, BeanAttributes<?> attributes) {
        if (type2 instanceof TypeVariable) {
            throw MetadataLogger.LOG.typeVariableIsNotAValidBeanType(beanType, attributes);
        }
        if (type2 instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type2;
            ExternalBeanAttributesFactory.checkBeanTypeNotATypeVariable(beanType, arrayType.getGenericComponentType(), attributes);
        }
    }

    private static void checkBeanTypeForWildcardsAndTypeVariables(Type beanType, Type type2, BeanAttributes<?> attributes) {
        if (type2 instanceof TypeVariable) {
            if (!attributes.getScope().equals(Dependent.class)) {
                throw MetadataLogger.LOG.beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped(beanType, attributes);
            }
        } else {
            if (type2 instanceof WildcardType) {
                throw MetadataLogger.LOG.parameterizedTypeContainingWildcardParameterIsNotAValidBeanType(beanType, attributes);
            }
            if (type2 instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type2;
                for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                    ExternalBeanAttributesFactory.checkBeanTypeForWildcardsAndTypeVariables(beanType, typeArgument, attributes);
                }
            } else if (type2 instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type2;
                ExternalBeanAttributesFactory.checkBeanTypeForWildcardsAndTypeVariables(beanType, arrayType.getGenericComponentType(), attributes);
            }
        }
    }

    public static void validateScope(BeanAttributes<?> attributes, BeanManager manager) {
        if (attributes.getScope() == null) {
            throw MetadataLogger.LOG.scopeNull(attributes);
        }
        if (!manager.isScope(attributes.getScope())) {
            throw MetadataLogger.LOG.notAScope(attributes.getScope(), attributes);
        }
    }
}

