/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.jboss.logging.LoggingLocale;

public final class Messages {
    private Messages() {
    }

    @Deprecated(forRemoval=true, since="3.6")
    public static <T> T getBundle(Class<T> type2) {
        return Messages.getBundle(type2, LoggingLocale.getLocale());
    }

    @Deprecated(forRemoval=true, since="3.6")
    public static <T> T getBundle(final Class<T> type2, final Locale locale) {
        if (System.getSecurityManager() == null) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(type2, MethodHandles.lookup());
                return Messages.doGetBundle(lookup, type2, locale);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("This library does not have private access to " + String.valueOf(type2));
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(type2, MethodHandles.lookup());
                    return Messages.doGetBundle(lookup, type2, locale);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("This library does not have private access to " + String.valueOf(type2));
                }
            }
        });
    }

    public static <T> T getBundle(MethodHandles.Lookup lookup, Class<T> type2) {
        return Messages.getBundle(lookup, type2, LoggingLocale.getLocale());
    }

    public static <T> T getBundle(MethodHandles.Lookup lookup, Class<T> type2, Locale locale) {
        if (System.getSecurityManager() == null) {
            return Messages.doGetBundle(lookup, type2, locale);
        }
        return (T)AccessController.doPrivileged(() -> Messages.doGetBundle(lookup, type2, locale));
    }

    private static <T> T doGetBundle(MethodHandles.Lookup lookup, Class<T> type2, Locale locale) {
        MethodHandle getter;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        Class<T> bundleClass = null;
        if (variant != null && !variant.isEmpty()) {
            try {
                bundleClass = lookup.findClass(Messages.join(type2.getName(), "$bundle", language, country, variant)).asSubclass(type2);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The given lookup does not have access to the implementation class");
            }
        }
        if (bundleClass == null && country != null && !country.isEmpty()) {
            try {
                bundleClass = lookup.findClass(Messages.join(type2.getName(), "$bundle", language, country, null)).asSubclass(type2);
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The given lookup does not have access to the implementation class");
            }
        }
        if (bundleClass == null && language != null && !language.isEmpty()) {
            try {
                bundleClass = lookup.findClass(Messages.join(type2.getName(), "$bundle", language, null, null)).asSubclass(type2);
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The given lookup does not have access to the implementation class");
            }
        }
        if (bundleClass == null) {
            try {
                bundleClass = lookup.findClass(Messages.join(type2.getName(), "$bundle", null, null, null)).asSubclass(type2);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid bundle " + String.valueOf(type2) + " (implementation not found)");
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The given lookup does not have access to the implementation class");
            }
        }
        try {
            getter = lookup.findStaticGetter(bundleClass, "INSTANCE", bundleClass);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Bundle implementation " + String.valueOf(bundleClass) + " has no instance field");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The given lookup does not have access to the implementation class instance field");
        }
        try {
            return type2.cast(getter.invoke());
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Bundle implementation " + String.valueOf(bundleClass) + " could not be instantiated", e);
        }
    }

    private static String join(String interfaceName, String a, String b, String c, String d) {
        StringBuilder build = new StringBuilder();
        build.append(interfaceName).append('_').append(a);
        if (b != null && b.length() > 0) {
            build.append('_');
            build.append(b);
        }
        if (c != null && c.length() > 0) {
            build.append('_');
            build.append(c);
        }
        if (d != null && d.length() > 0) {
            build.append('_');
            build.append(d);
        }
        return build.toString();
    }
}

