/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public final class Signatures {
    static final char WILDCARD_UPPER_BOUND = '+';
    static final char WILDCARD_LOWER_BOUND = '-';
    static final char WILDCARD_NO_BOUND = '*';
    static final char TYPE_PARAM_DEL_START = '<';
    static final char TYPE_PARAM_DEL_END = '>';
    static final char SEMICOLON = ';';
    static final char COLON = ':';

    private Signatures() {
    }

    public static String methodSignature(Method method) {
        StringBuilder builder = new StringBuilder();
        TypeVariable<Method>[] typeParams = method.getTypeParameters();
        if (typeParams.length > 0) {
            builder.append('<');
            for (TypeVariable<Method> typeParam : typeParams) {
                Signatures.typeParameter(typeParam, builder);
            }
            builder.append('>');
        }
        Type[] params = method.getGenericParameterTypes();
        builder.append('(');
        if (params.length > 0) {
            for (Type paramType : params) {
                Signatures.javaType(paramType, builder);
            }
        }
        builder.append(')');
        Signatures.javaType(method.getGenericReturnType(), builder);
        Type[] exceptions = method.getGenericExceptionTypes();
        if (exceptions.length > 0) {
            for (Type exceptionType : exceptions) {
                builder.append('^');
                Signatures.javaType(exceptionType, builder);
            }
        }
        return builder.toString();
    }

    private static void typeParameter(TypeVariable<?> typeVariable, StringBuilder builder) {
        builder.append(typeVariable.getName());
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length > 0) {
            for (int i = 0; i < bounds.length; ++i) {
                if (i == 0 && Signatures.getTypeParamBoundRawType(bounds[i]).isInterface()) {
                    builder.append(':');
                }
                builder.append(':');
                Signatures.javaType(bounds[i], builder);
            }
        } else {
            builder.append(':');
            Signatures.javaType(Object.class, builder);
        }
    }

    private static void javaType(Type type2, StringBuilder builder) {
        if (type2 instanceof Class) {
            Signatures.nonGenericType((Class)type2, builder);
        } else if (type2 instanceof ParameterizedType) {
            Signatures.parameterizedType((ParameterizedType)type2, builder);
        } else if (type2 instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type2;
            builder.append('[');
            Signatures.javaType(genericArrayType.getGenericComponentType(), builder);
        } else if (type2 instanceof WildcardType) {
            Signatures.wildcardType((WildcardType)type2, builder);
        } else if (type2 instanceof TypeVariable) {
            Signatures.typeVariable((TypeVariable)type2, builder);
        } else {
            throw new IllegalArgumentException("Signature encoding error - unsupported type: " + type2);
        }
    }

    private static void wildcardType(WildcardType wildcard, StringBuilder builder) {
        if (wildcard.getLowerBounds().length > 0) {
            for (Type lowerBound : wildcard.getLowerBounds()) {
                builder.append('-');
                Signatures.javaType(lowerBound, builder);
            }
        } else if (wildcard.getUpperBounds().length == 0 || wildcard.getUpperBounds().length == 1 && Object.class.equals((Object)wildcard.getUpperBounds()[0])) {
            builder.append('*');
        } else {
            for (Type upperBound : wildcard.getUpperBounds()) {
                builder.append('+');
                Signatures.javaType(upperBound, builder);
            }
        }
    }

    private static void typeVariable(TypeVariable<?> typeVariable, StringBuilder builder) {
        builder.append('T');
        builder.append(typeVariable.getName());
        builder.append(';');
    }

    private static void parameterizedType(ParameterizedType parameterizedType, StringBuilder builder) {
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            throw new IllegalStateException(String.format("Signature encoding error - unsupported raw type: %s of parameterized type: %s", parameterizedType, rawType));
        }
        builder.append(Signatures.classTypeBase(((Class)rawType).getName()));
        builder.append('<');
        for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
            Signatures.javaType(actualTypeArgument, builder);
        }
        builder.append('>');
        builder.append(';');
    }

    private static void nonGenericType(Class<?> clazz, StringBuilder builder) {
        if (Void.TYPE.equals(clazz)) {
            builder.append("V");
        } else if (Byte.TYPE.equals(clazz)) {
            builder.append("B");
        } else if (Character.TYPE.equals(clazz)) {
            builder.append("C");
        } else if (Double.TYPE.equals(clazz)) {
            builder.append("D");
        } else if (Float.TYPE.equals(clazz)) {
            builder.append("F");
        } else if (Integer.TYPE.equals(clazz)) {
            builder.append("I");
        } else if (Long.TYPE.equals(clazz)) {
            builder.append("J");
        } else if (Short.TYPE.equals(clazz)) {
            builder.append("S");
        } else if (Boolean.TYPE.equals(clazz)) {
            builder.append("Z");
        } else if (clazz.isArray()) {
            builder.append(Signatures.encodeClassName(clazz.getName()));
        } else {
            builder.append(Signatures.classTypeBase(clazz.getName()) + ";");
        }
    }

    private static String classTypeBase(String className) {
        return "L" + Signatures.encodeClassName(className);
    }

    private static String encodeClassName(String className) {
        return className.replace('.', '/');
    }

    private static <T> Class<T> getTypeParamBoundRawType(Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType && ((ParameterizedType)type2).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type2).getRawType();
        }
        if (type2 instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type2;
            Type[] bounds = variable.getBounds();
            return Signatures.getBound(bounds);
        }
        throw new IllegalStateException("Signature encoding error - unexpected type parameter bound type: " + type2);
    }

    private static <T> Class<T> getBound(Type[] bounds) {
        if (bounds.length == 0) {
            return Object.class;
        }
        return Signatures.getTypeParamBoundRawType(bounds[0]);
    }
}

