/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.hibernate.validator.cdi.internal.ValidationProviderHelper;

public class ValidatorBean
implements Bean<Validator>,
PassivationCapable {
    private final BeanManager beanManager;
    private final ValidationProviderHelper validationProviderHelper;
    private final Set<Type> types;
    private final Bean<?> validatorFactoryBean;

    public ValidatorBean(BeanManager beanManager, Bean<?> validatorFactoryBean, ValidationProviderHelper validationProviderHelper) {
        this.beanManager = beanManager;
        this.validatorFactoryBean = validatorFactoryBean;
        this.validationProviderHelper = validationProviderHelper;
        this.types = validationProviderHelper.determineValidatorCdiTypes();
    }

    @Override
    public Class<?> getBeanClass() {
        return this.validationProviderHelper.getValidatorBeanClass();
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.validationProviderHelper.getQualifiers();
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    @Override
    public Validator create(CreationalContext<Validator> ctx) {
        ValidatorFactory validatorFactory = this.createValidatorFactory();
        return validatorFactory.getValidator();
    }

    private ValidatorFactory createValidatorFactory() {
        CreationalContext<?> context = this.beanManager.createCreationalContext(this.validatorFactoryBean);
        return (ValidatorFactory)this.beanManager.getReference(this.validatorFactoryBean, (Type)((Object)ValidatorFactory.class), context);
    }

    @Override
    public void destroy(Validator instance, CreationalContext<Validator> ctx) {
    }

    @Override
    public String getId() {
        return ValidatorBean.class.getName() + "_" + (this.validationProviderHelper.isDefaultProvider() ? "default" : "hv");
    }

    public String toString() {
        return "ValidatorBean [id=" + this.getId() + ", qualifiers=" + String.valueOf(this.getQualifiers()) + "]";
    }
}

