/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.ejb.codegen.ClassGenerator;
import java.lang.annotation.Annotation;
import java.security.ProtectionDomain;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.weld.services.WeldProxyException;
import org.jboss.weld.serialization.spi.ProxyServices;

public class ProxyServicesImpl
implements ProxyServices {
    private final ClassLoaderHierarchy classLoaderHierarchy;

    public ProxyServicesImpl(ServiceLocator services) {
        this.classLoaderHierarchy = services.getService(ClassLoaderHierarchy.class, new Annotation[0]);
    }

    @Override
    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len) throws ClassFormatError {
        return this.defineClass(originalClass, className, classBytes, off, len, null);
    }

    @Override
    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        ClassLoader loader = this.getClassLoaderforBean(originalClass);
        if (protectionDomain == null) {
            return this.defineClass(loader, className, classBytes, off, len);
        }
        return this.defineClass(loader, className, classBytes, off, len, protectionDomain);
    }

    @Override
    public Class<?> loadClass(Class<?> originalClass, String classBinaryName) throws ClassNotFoundException {
        return this.getClassLoaderforBean(originalClass).loadClass(classBinaryName);
    }

    @Override
    public void cleanup() {
    }

    private ClassLoader getClassLoaderforBean(Class<?> originalClass) {
        ClassLoader originalClassLoader = originalClass.getClassLoader();
        if (this.isApplicationClassLoader(originalClassLoader)) {
            return originalClassLoader;
        }
        ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
        if (threadCL != null) {
            return threadCL;
        }
        throw new WeldProxyException("Could not determine classloader for " + String.valueOf(originalClass));
    }

    private boolean isApplicationClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader.equals(this.classLoaderHierarchy.getCommonClassLoader())) {
                return true;
            }
            classLoader = classLoader.getParent();
        }
        return false;
    }

    private Class<?> loadClassByThreadCL(String className) throws ClassNotFoundException {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    private Class<?> defineClass(ClassLoader loader, String className, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        try {
            return ClassGenerator.defineClass(loader, className, b, 0, len, protectionDomain);
        }
        catch (Exception e) {
            throw new WeldProxyException("Could not define class " + className, e);
        }
    }

    private Class<?> defineClass(ClassLoader loader, String className, byte[] b, int off, int len) {
        try {
            return ClassGenerator.defineClass(loader, className, b, 0, len);
        }
        catch (Exception e) {
            throw new WeldProxyException("Could not define class " + className, e);
        }
    }
}

