/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.session.PersistentManagerBase;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.web.ha.LogFacade;
import org.glassfish.web.ha.session.management.SessionFactory;

public abstract class ReplicationManagerBase<T extends Storeable>
extends PersistentManagerBase {
    protected BackingStore<String, T> backingStore;
    protected SessionFactory sessionFactory;
    protected static final String name = "ReplicationManagerBase";
    protected Logger _logger = LogFacade.getLogger();
    protected boolean relaxCacheVersionSemantics = false;
    protected boolean disableJreplica = false;

    public BackingStore<String, T> getBackingStore() {
        return this.backingStore;
    }

    public abstract void createBackingStore(String var1, String var2, Class<T> var3, Map<String, Object> var4);

    public Session createNewSession() {
        return this.sessionFactory.createSession(this);
    }

    @Override
    public Session createEmptySession() {
        Session sess = this.sessionFactory.createSession(this);
        return sess;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setBackingStore(BackingStore<String, T> backingStore) {
        this.backingStore = backingStore;
    }

    public void doRemove(String id) {
        try {
            this.backingStore.remove(id);
        }
        catch (BackingStoreException e) {
            this._logger.warning("AS-WEB-HA-00006");
        }
    }

    @Override
    public boolean isSessionVersioningSupported() {
        return true;
    }

    @Override
    public Session findSession(String id, String version) throws IOException {
        Session cachedSession;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("in findSession: version=" + version);
        }
        if (!this.isSessionIdValid(id) || version == null) {
            return null;
        }
        Session loadedSession = null;
        long requiredVersion = 0L;
        long cachedVersion = -1L;
        try {
            requiredVersion = Long.parseLong(version);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Required version " + requiredVersion);
            }
        }
        catch (NumberFormatException ex) {
            this._logger.log(Level.INFO, "AS-WEB-HA-00007", ex);
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("findSession:requiredVersion=" + requiredVersion);
        }
        if ((cachedSession = (Session)this.sessions.get(id)) != null) {
            cachedVersion = cachedSession.getVersion();
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("findSession:cachedVersion=" + cachedVersion);
        }
        if (cachedVersion == requiredVersion || this.isRelaxCacheVersionSemantics() && cachedVersion > requiredVersion) {
            return cachedSession;
        }
        if (cachedVersion < requiredVersion && !this.isRelaxCacheVersionSemantics()) {
            this.removeSessionFromManagerCache(cachedSession);
            cachedSession = null;
            cachedVersion = -1L;
        }
        loadedSession = requiredVersion != -1L ? this.swapIn(id, version) : this.swapIn(id);
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("findSession:swappedInSession=" + String.valueOf(loadedSession));
        }
        if (loadedSession == null || loadedSession.getVersion() < cachedVersion) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("ReplicationManagerBase>>findSession:returning cached version:" + cachedVersion);
            }
            return cachedSession;
        }
        if (loadedSession.getVersion() < requiredVersion && !this.isRelaxCacheVersionSemantics()) {
            loadedSession = null;
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("ReplicationManagerBase>>findSession:returning:" + String.valueOf(loadedSession));
        }
        return loadedSession;
    }

    public boolean isRelaxCacheVersionSemantics() {
        return this.relaxCacheVersionSemantics;
    }

    public void setRelaxCacheVersionSemantics(boolean value) {
        this.relaxCacheVersionSemantics = value;
    }

    public void removeSessionFromManagerCache(Session session) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("in " + this.getClass().getName() + ">>removeSessionFromManagerCache:session = " + String.valueOf(session));
        }
        if (session == null) {
            return;
        }
        Session removed = null;
        removed = (Session)this.sessions.remove(session.getIdInternal());
        if (removed != null && this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("Remove from manager cache id=" + session.getId());
        }
    }

    public void setDisableJreplica(boolean disableJreplica) {
        this.disableJreplica = disableJreplica;
    }

    public boolean isDisableJreplica() {
        return this.disableJreplica;
    }

    public abstract void doValveSave(Session var1);

    public abstract String getReplicaFromPredictor(String var1, String var2);
}

