/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha;

import com.sun.web.security.CNonceCacheImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.NonceInfo;
import org.glassfish.web.ha.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service(name="HA-CNonceCache")
@PerLookup
public class HACNonceCacheImpl
implements CNonceCache {
    @Inject
    private ServiceLocator services;
    private CNonceCacheImpl localStore;
    private BackingStore<String, NonceInfo> backingStore = null;
    private String storeName = null;
    private Map<String, String> props;
    private static final String BS_TYPE_REPLICATED = "replicated";
    private static final Logger logger = LogFacade.getLogger();

    @Override
    public void setCnonceCacheSize(long cnonceCacheSize) {
        this.localStore.setCnonceCacheSize(cnonceCacheSize);
    }

    @Override
    public void setNonceValidity(long nonceValidity) {
        this.localStore.setNonceValidity(nonceValidity);
    }

    @Override
    public long getCnonceCacheSize() {
        return this.localStore.getCnonceCacheSize();
    }

    @Override
    public long getNonceValidity() {
        return this.localStore.getNonceValidity();
    }

    @Override
    public int size() {
        return this.localStore.size();
    }

    @Override
    public boolean isEmpty() {
        return this.localStore.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.localStore.containsKey((String)o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.localStore.containsValue((NonceInfo)o);
    }

    @Override
    public NonceInfo get(Object o) {
        NonceInfo ret = (NonceInfo)this.localStore.get((String)o);
        if (ret == null && this.backingStore != null) {
            try {
                return this.backingStore.load((String)o, null);
            }
            catch (BackingStoreException ex) {
                logger.log(Level.WARNING, null, ex);
            }
        }
        return ret;
    }

    @Override
    public NonceInfo put(String k, NonceInfo v) {
        NonceInfo ret = this.localStore.put(k, v);
        if (this.backingStore == null) {
            return ret;
        }
        try {
            if (this.removeEldestEntry(null)) {
                this.backingStore.remove(this.localStore.getEldestCNonce());
            }
            this.backingStore.save(k, v, true);
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        return ret;
    }

    @Override
    public NonceInfo remove(Object o) {
        NonceInfo ret = (NonceInfo)this.localStore.remove((String)o);
        if (this.backingStore == null) {
            return ret;
        }
        try {
            this.backingStore.remove((String)o);
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        return ret;
    }

    @Override
    public void putAll(Map<? extends String, ? extends NonceInfo> map) {
        throw new UnsupportedOperationException("putAll : Not  Supported");
    }

    @Override
    public void clear() {
        if (this.backingStore != null) {
            for (String s : this.keySet()) {
                try {
                    this.backingStore.remove(s);
                }
                catch (BackingStoreException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
        this.localStore.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.localStore.keySet();
    }

    @Override
    public Collection<NonceInfo> values() {
        return this.localStore.values();
    }

    @Override
    public Set<Map.Entry<String, NonceInfo>> entrySet() {
        return this.localStore.entrySet();
    }

    protected boolean removeEldestEntry(Map.Entry<String, NonceInfo> eldest) {
        return (long)this.size() > this.getCnonceCacheSize();
    }

    public void postConstruct() {
        this.localStore = new CNonceCacheImpl();
        try {
            BackingStoreConfiguration bsConfig = new BackingStoreConfiguration();
            bsConfig.setClusterName(this.props.get("cluster_name")).setInstanceName(this.props.get("instance_name")).setStoreName(this.storeName).setKeyClazz(String.class).setValueClazz(NonceInfo.class);
            BackingStoreFactory bsFactory = this.services.getService(BackingStoreFactory.class, BS_TYPE_REPLICATED, new Annotation[0]);
            this.backingStore = bsFactory.createBackingStore(bsConfig);
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, null, ex);
        }
    }

    @Override
    public void init(long size, String name, long validity, Map<String, String> props) {
        this.storeName = name;
        this.props = props;
        this.postConstruct();
        this.localStore.setCnonceCacheSize(size);
        this.localStore.setNonceValidity(validity);
    }

    @Override
    public void destroy() {
        this.clear();
        try {
            if (this.backingStore != null) {
                this.backingStore.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

