/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node.runtime.gf;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.WebServiceEndpointRuntimeNode;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServletNode
extends DeploymentDescriptorNode<WebComponentDescriptor> {
    protected WebComponentDescriptor descriptor;

    public ServletNode() {
        this.registerElementHandler(new XMLElement("webservice-endpoint"), WebServiceEndpointRuntimeNode.class);
    }

    @Override
    public WebComponentDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new WebComponentDescriptorImpl();
        }
        return this.descriptor;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("servlet-name".equals(element.getQName())) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof WebBundleDescriptor) {
                this.descriptor = ((WebBundleDescriptor)parentDesc).getWebComponentByCanonicalName(value);
            }
        } else if ("principal-name".equals(element.getQName())) {
            if (this.descriptor != null && this.descriptor.getRunAsIdentity() != null) {
                this.descriptor.getRunAsIdentity().setPrincipal(value);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, WebComponentDescriptor descriptor) {
        WebServicesDescriptor webServices = descriptor.getWebBundleDescriptor().getWebServices();
        if (descriptor.getRunAsIdentity() != null || webServices.hasEndpointsImplementedBy(descriptor)) {
            Element servletNode = ServletNode.appendChild(parent, nodeName);
            ServletNode.appendTextChild((Node)servletNode, "servlet-name", descriptor.getCanonicalName());
            if (descriptor.getRunAsIdentity() != null) {
                ServletNode.appendTextChild((Node)servletNode, "principal-name", descriptor.getRunAsIdentity().getPrincipal());
            }
            WebServiceEndpointRuntimeNode wsRuntime = new WebServiceEndpointRuntimeNode();
            wsRuntime.writeWebServiceEndpointInfo((Node)servletNode, descriptor);
            return servletNode;
        }
        return null;
    }
}

