/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.net.URLPattern;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.web.LogFacade;
import org.glassfish.web.deployment.node.WebCommonNode;

public class ServletMappingNode
extends DeploymentDescriptorNode<Descriptor> {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    private String servletName;
    private String urlPattern;

    @Override
    public Descriptor getDescriptor() {
        return null;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("servlet-name".equals(element.getQName())) {
            this.servletName = value;
        }
        if ("url-pattern".equals(element.getQName())) {
            if (!URLPattern.isValid(value)) {
                Object parent;
                Object trimmedUrl = value.trim();
                if ("\"\"".equals(trimmedUrl)) {
                    trimmedUrl = "";
                }
                if ((parent = this.getParentNode().getDescriptor()) instanceof WebBundleDescriptor && ((WebBundleDescriptor)parent).getSpecVersion().equals("2.2") && !((String)trimmedUrl).startsWith("/") && !((String)trimmedUrl).startsWith("*.")) {
                    trimmedUrl = "/" + (String)trimmedUrl;
                }
                if (URLPattern.isValid((String)trimmedUrl)) {
                    if (URLPattern.containsCRorLF(value)) {
                        DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.urlcontainscrlf", new Object[]{value});
                    }
                    value = trimmedUrl;
                } else {
                    throw new IllegalArgumentException(MessageFormat.format(rb.getString("AS-WEB-GLUE-00279"), value));
                }
            }
            this.urlPattern = value;
            XMLNode<?> parentNode = this.getParentNode();
            if (parentNode instanceof WebCommonNode) {
                ((WebCommonNode)parentNode).addServletMapping(this.servletName, this.urlPattern);
            } else {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "AS-DEPLOYMENT-00015", new Object[]{this.getXMLRootTag(), "servlet-mapping", parentNode.getDescriptor().getClass()});
            }
        }
    }
}

