/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ErrorPageDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.JspConfigDefinitionDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.util.ComponentPostVisitor;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.web.MimeMapping;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.web.deployment.descriptor.AbsoluteOrderingDescriptor;
import org.glassfish.web.deployment.descriptor.SecurityConstraintImpl;
import org.glassfish.web.deployment.descriptor.ServletFilterDescriptor;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorImpl;
import org.glassfish.web.deployment.descriptor.WebFragmentDescriptor;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;
import org.glassfish.web.deployment.util.WebBundleTracerVisitor;
import org.glassfish.web.deployment.util.WebBundleValidator;
import org.glassfish.web.deployment.util.WebBundleVisitor;

public class WebBundleDescriptorImpl
extends WebBundleDescriptor {
    private static final long serialVersionUID = 1L;
    private AbsoluteOrderingDescriptor absOrdering;
    private SunWebApp sunWebApp;
    private final Set<String> conflictedMimeMappingExtensions = new OrderedSet<String>();

    @Override
    public ComponentVisitor getBundleVisitor() {
        return new WebBundleValidator();
    }

    @Override
    public String getDefaultSpecVersion() {
        return "6.0";
    }

    public AbsoluteOrderingDescriptor getAbsoluteOrderingDescriptor() {
        return this.absOrdering;
    }

    public void setAbsoluteOrderingDescriptor(AbsoluteOrderingDescriptor absOrdering) {
        this.absOrdering = absOrdering;
    }

    @Override
    public SunWebApp getSunDescriptor() {
        if (this.sunWebApp == null) {
            this.sunWebApp = new SunWebAppImpl();
        }
        return this.sunWebApp;
    }

    @Override
    public void setSunDescriptor(SunWebApp webApp) {
        this.sunWebApp = webApp;
    }

    @Override
    public DescriptorVisitor getTracerVisitor() {
        return new WebBundleTracerVisitor();
    }

    @Override
    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof WebBundleVisitor || aVisitor instanceof ComponentPostVisitor) {
            this.visit((ComponentVisitor)aVisitor);
        } else {
            super.visit(aVisitor);
        }
    }

    @Override
    public void visit(ComponentVisitor aVisitor) {
        super.visit(aVisitor);
        aVisitor.accept(this);
    }

    @Override
    public Collection<? extends PersistenceUnitDescriptor> findReferencedPUs() {
        HashSet<? extends PersistenceUnitDescriptor> pus = new HashSet<PersistenceUnitDescriptor>(WebBundleDescriptorImpl.findReferencedPUsViaPURefs(this));
        pus.addAll(WebBundleDescriptorImpl.findReferencedPUsViaPCRefs(this));
        if (this.extensions.containsKey(EjbBundleDescriptor.class)) {
            for (RootDeploymentDescriptor extension : (List)this.extensions.get(EjbBundleDescriptor.class)) {
                pus.addAll(((EjbBundleDescriptor)extension).findReferencedPUs());
            }
        }
        return pus;
    }

    @Override
    protected void addCommonWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor, boolean descriptorFragment) {
        this.addBundleDescriptor(webBundleDescriptor);
        for (WebComponentDescriptor webComponentDesc : webBundleDescriptor.getWebComponentDescriptors()) {
            WebComponentDescriptorImpl webComponentDescriptor = new WebComponentDescriptorImpl(webComponentDesc);
            webComponentDescriptor.setWebBundleDescriptor(null);
            ArrayList<String> removeUrlPatterns = new ArrayList<String>();
            for (String urlPattern : webComponentDescriptor.getUrlPatternsSet()) {
                Map<String, String> map = this.getUrlPatternToServletNameMap(false);
                String servletName = map == null ? null : map.get(urlPattern);
                if (servletName == null || servletName.equals(webComponentDescriptor.getCanonicalName())) continue;
                removeUrlPatterns.add(urlPattern);
            }
            webComponentDescriptor.getUrlPatternsSet().removeAll(removeUrlPatterns);
            this.addWebComponentDescriptor(webComponentDescriptor);
        }
        this.addContextParameters(webBundleDescriptor.getContextParameters());
        if (webBundleDescriptor instanceof WebBundleDescriptorImpl) {
            this.addConflictedMimeMappingExtensions(((WebBundleDescriptorImpl)webBundleDescriptor).getConflictedMimeMappingExtensions());
        }
        this.combineMimeMappings(webBundleDescriptor.getMimeMappings());
        for (ErrorPageDescriptor errPageDesc : webBundleDescriptor.getErrorPageDescriptors()) {
            this.addErrorPageDescriptor(errPageDesc);
        }
        this.addAppListeners(webBundleDescriptor.getAppListeners());
        if (webBundleDescriptor.isDenyUncoveredHttpMethods()) {
            this.setDenyUncoveredHttpMethods(true);
        }
        this.combineSecurityConstraints(this.getSecurityConstraints(), webBundleDescriptor.getSecurityConstraints());
        this.combineServletFilters(webBundleDescriptor);
        this.combineServletFilterMappings(webBundleDescriptor);
        if (this.getLocaleEncodingMappingListDescriptor() == null) {
            this.setLocaleEncodingMappingListDescriptor(webBundleDescriptor.getLocaleEncodingMappingListDescriptor());
        }
        if (webBundleDescriptor.getJspConfigDescriptor() != null) {
            JspConfigDefinitionDescriptor jspConfigDesc = this.getJspConfigDescriptor();
            if (jspConfigDesc == null) {
                this.setJspConfigDescriptor(new JspConfigDefinitionDescriptor());
            }
            this.addJspDescriptor(webBundleDescriptor.getJspConfigDescriptor());
        }
        WebServicesDescriptor thisWebServices = this.getWebServices();
        WebServicesDescriptor otherWebServices = webBundleDescriptor.getWebServices();
        for (WebService ws : otherWebServices.getWebServices()) {
            thisWebServices.addWebService(new WebService(ws));
        }
        if (this.getSessionConfig() == null) {
            this.setSessionConfig(webBundleDescriptor.getSessionConfig());
        }
        this.combineLoginConfiguration(webBundleDescriptor);
        if (descriptorFragment) {
            boolean otherDistributable = webBundleDescriptor.isDistributable();
            this.setDistributable(this.isDistributable() && otherDistributable);
        }
        this.combinePostConstructDescriptors(webBundleDescriptor);
        this.combinePreDestroyDescriptors(webBundleDescriptor);
        this.addJndiNameEnvironment(webBundleDescriptor);
    }

    protected void combineMimeMappings(Set<MimeMapping> mimeMappings) {
        for (MimeMapping mm : this.getMimeMappings()) {
            this.conflictedMimeMappingExtensions.remove(mm.getExtension());
        }
        if (!this.conflictedMimeMappingExtensions.isEmpty()) {
            throw new IllegalArgumentException("There are more than one Mime mapping defined in web fragments with the same extension.");
        }
        for (MimeMapping mimeMap : mimeMappings) {
            this.addMimeMapping(mimeMap);
        }
    }

    public Set<String> getConflictedMimeMappingExtensions() {
        return this.conflictedMimeMappingExtensions;
    }

    protected void addConflictedMimeMappingExtensions(Set<String> conflicted) {
        this.conflictedMimeMappingExtensions.addAll(conflicted);
    }

    protected void combineSecurityConstraints(Set<SecurityConstraint> firstScSet, Set<SecurityConstraint> secondScSet) {
        HashSet<String> allUrlPatterns = new HashSet<String>();
        for (SecurityConstraint sc : firstScSet) {
            for (WebResourceCollection wrc : sc.getWebResourceCollections()) {
                allUrlPatterns.addAll(wrc.getUrlPatterns());
            }
        }
        for (SecurityConstraint sc : secondScSet) {
            SecurityConstraintImpl newSc = new SecurityConstraintImpl((SecurityConstraintImpl)sc);
            boolean addSc = false;
            Iterator<WebResourceCollection> iter = newSc.getWebResourceCollections().iterator();
            while (iter.hasNext()) {
                WebResourceCollection wrc = iter.next();
                Set<String> urlPatterns = wrc.getUrlPatterns();
                urlPatterns.removeAll(allUrlPatterns);
                boolean isEmpty = urlPatterns.isEmpty();
                boolean bl = addSc = addSc || !isEmpty;
                if (!isEmpty) continue;
                iter.remove();
            }
            if (!addSc) continue;
            firstScSet.add(newSc);
        }
    }

    protected void combineServletFilters(WebBundleDescriptor webBundleDescriptor) {
        for (ServletFilter servletFilter : webBundleDescriptor.getServletFilters()) {
            ServletFilterDescriptor servletFilterDesc = (ServletFilterDescriptor)servletFilter;
            String name = servletFilter.getName();
            ServletFilterDescriptor aServletFilterDesc = null;
            for (ServletFilter sf : this.getServletFilters()) {
                if (!name.equals(sf.getName())) continue;
                aServletFilterDesc = (ServletFilterDescriptor)sf;
                break;
            }
            if (aServletFilterDesc != null) {
                if (!aServletFilterDesc.isConflict(servletFilterDesc)) {
                    if (aServletFilterDesc.getClassName().isEmpty()) {
                        aServletFilterDesc.setClassName(servletFilter.getClassName());
                    }
                    if (aServletFilterDesc.isAsyncSupported() == null) {
                        aServletFilterDesc.setAsyncSupported(servletFilter.isAsyncSupported());
                    }
                }
                String className = aServletFilterDesc.getClassName();
                if (!servletFilterDesc.isConflict() || className != null && !className.isEmpty()) continue;
                throw new IllegalArgumentException("Two or more web fragments define the same Filter with conflicting implementation class names that are not overridden by the web.xml");
            }
            if (servletFilterDesc.isConflict()) {
                throw new IllegalArgumentException("One or more web fragments define the same Filter in a conflicting way, and the Filter is not defined in web.xml");
            }
            this.getServletFilters().add(servletFilterDesc);
        }
    }

    protected void combineServletFilterMappings(WebBundleDescriptor webBundleDescriptor) {
        ServletFilterMappingInfo sfmInfo;
        HashMap<String, ServletFilterMappingInfo> map = new HashMap<String, ServletFilterMappingInfo>();
        for (ServletFilterMapping sfMapping : this.getServletFilterMappings()) {
            sfmInfo = (ServletFilterMappingInfo)map.get(sfMapping.getName());
            if (sfmInfo == null) {
                sfmInfo = new ServletFilterMappingInfo();
                sfmInfo.servletFilterMapping = sfMapping;
                map.put(sfMapping.getName(), sfmInfo);
            }
            if (!sfmInfo.hasMapping) {
                boolean bl = sfmInfo.hasMapping = !sfMapping.getServletNames().isEmpty() && !sfMapping.getUrlPatterns().isEmpty();
            }
            if (sfmInfo.hasDispatcher) continue;
            sfmInfo.hasDispatcher = !sfMapping.getDispatchers().isEmpty();
        }
        for (ServletFilterMapping sfMapping : webBundleDescriptor.getServletFilterMappings()) {
            sfmInfo = (ServletFilterMappingInfo)map.get(sfMapping.getName());
            if (sfmInfo != null) {
                if (!sfmInfo.hasMapping) {
                    sfmInfo.servletFilterMapping.getServletNames().addAll(sfMapping.getServletNames());
                    sfmInfo.servletFilterMapping.getUrlPatterns().addAll(sfMapping.getUrlPatterns());
                }
                if (sfmInfo.hasDispatcher) continue;
                sfmInfo.servletFilterMapping.getDispatchers().addAll(sfMapping.getDispatchers());
                continue;
            }
            this.addServletFilterMapping(sfMapping);
        }
    }

    protected void combineLoginConfiguration(WebBundleDescriptor webBundleDescriptor) {
        if (this.getLoginConfiguration() == null) {
            WebFragmentDescriptor fragment;
            if (webBundleDescriptor instanceof WebFragmentDescriptor && (fragment = (WebFragmentDescriptor)webBundleDescriptor).isConflictLoginConfig()) {
                throw new IllegalArgumentException("There are more than one login-config defined in web fragments with different values");
            }
            this.setLoginConfiguration(webBundleDescriptor.getLoginConfiguration());
        }
    }

    protected void combinePostConstructDescriptors(WebBundleDescriptor webBundleDescriptor) {
        LifecycleCallbackDescriptor lccd;
        boolean isFromXml = false;
        Iterator<LifecycleCallbackDescriptor> iterator = this.getPostConstructDescriptors().iterator();
        while (iterator.hasNext() && !(isFromXml = (lccd = iterator.next()).getMetadataSource() == MetadataSource.XML)) {
        }
        if (!isFromXml) {
            this.getPostConstructDescriptors().addAll(webBundleDescriptor.getPostConstructDescriptors());
        }
    }

    protected void combinePreDestroyDescriptors(WebBundleDescriptor webBundleDescriptor) {
        LifecycleCallbackDescriptor lccd;
        boolean isFromXml = false;
        Iterator<LifecycleCallbackDescriptor> iterator = this.getPreDestroyDescriptors().iterator();
        while (iterator.hasNext() && !(isFromXml = (lccd = iterator.next()).getMetadataSource() == MetadataSource.XML)) {
        }
        if (!isFromXml) {
            this.getPreDestroyDescriptors().addAll(webBundleDescriptor.getPreDestroyDescriptors());
        }
    }

    @Override
    public void addJndiNameEnvironment(JndiNameEnvironment env) {
        this.combineEnvironmentEntries(env);
        this.combineResourceReferenceDescriptors(env);
        this.combineEjbReferenceDescriptors(env);
        this.combineServiceReferenceDescriptors(env);
        this.combineResourceEnvReferenceDescriptors(env);
        this.combineMessageDestinationReferenceDescriptors(env);
        this.combineEntityManagerReferenceDescriptors(env);
        this.combineEntityManagerFactoryReferenceDescriptors(env);
        this.combineAllResourceDescriptors(env);
    }

    protected void combineEnvironmentEntries(JndiNameEnvironment env) {
        for (EnvironmentProperty property : env.getEnvironmentProperties()) {
            WebFragmentDescriptor fragment;
            EnvironmentProperty entry = this.findEnvironmentEntryByName(property.getName());
            if (entry != null) {
                this.combineInjectionTargets(entry, property);
                if (!property.isSetValueCalled() || entry.isSetValueCalled() || entry.hasInjectionTargetFromXml()) continue;
                entry.setValue(property.getValue());
                continue;
            }
            if (env instanceof WebFragmentDescriptor && (fragment = (WebFragmentDescriptor)env).isConflictEnvironmentEntry()) {
                throw new IllegalArgumentException("There are more than one environment entries defined in web fragments with the same name, but not overrided in web.xml");
            }
            this.addEnvironmentEntry(property);
        }
    }

    protected void combineResourceReferenceDescriptors(JndiNameEnvironment env) {
        for (ResourceReferenceDescriptor resRef : env.getResourceReferenceDescriptors()) {
            WebFragmentDescriptor fragment;
            ResourceReferenceDescriptor rrd = this.findResourceReferenceByName(resRef.getName());
            if (rrd != null) {
                this.combineInjectionTargets(rrd, resRef);
                continue;
            }
            if (env instanceof WebFragmentDescriptor && (fragment = (WebFragmentDescriptor)env).isConflictResourceReference()) {
                throw new IllegalArgumentException("There are more than one resource references defined in web fragments with the same name, but not overrided in web.xml");
            }
            this.addResourceReferenceDescriptor(resRef);
        }
    }

    protected void combineEjbReferenceDescriptors(JndiNameEnvironment env) {
        for (EjbReferenceDescriptor ejbRef : env.getEjbReferenceDescriptors()) {
            WebFragmentDescriptor fragment;
            EjbReferenceDescriptor ejbRefDesc = this.findEjbReference(ejbRef.getName());
            if (ejbRefDesc != null) {
                this.combineInjectionTargets(ejbRefDesc, ejbRef);
                continue;
            }
            if (env instanceof WebFragmentDescriptor && (fragment = (WebFragmentDescriptor)env).isConflictEjbReference()) {
                throw new IllegalArgumentException("There are more than one ejb references defined in web fragments with the same name, but not overrided in web.xml");
            }
            this.addEjbReferenceDescriptor(ejbRef);
        }
    }

    protected void combineServiceReferenceDescriptors(JndiNameEnvironment env) {
        for (ServiceReferenceDescriptor serviceRef : env.getServiceReferenceDescriptors()) {
            WebFragmentDescriptor fragment;
            ServiceReferenceDescriptor sr = this.findServiceReferenceByName(serviceRef.getName());
            if (sr != null) {
                this.combineInjectionTargets(sr, serviceRef);
                continue;
            }
            if (env instanceof WebFragmentDescriptor && (fragment = (WebFragmentDescriptor)env).isConflictServiceReference()) {
                throw new IllegalArgumentException("There are more than one service references defined in web fragments with the same name, but not overrided in web.xml");
            }
            this.addServiceReferenceDescriptor(serviceRef);
        }
    }

    protected void combineResourceEnvReferenceDescriptors(JndiNameEnvironment env) {
        for (ResourceEnvReferenceDescriptor jdRef : env.getResourceEnvReferenceDescriptors()) {
            WebFragmentDescriptor fragment;
            ResourceEnvReferenceDescriptor jdr = this.findResourceEnvReferenceByName(jdRef.getName());
            if (jdr != null) {
                this.combineInjectionTargets(jdr, jdRef);
                continue;
            }
            if (env instanceof WebFragmentDescriptor && (fragment = (WebFragmentDescriptor)env).isConflictResourceEnvReference()) {
                throw new IllegalArgumentException("There are more than one resource env references defined in web fragments with the same name, but not overrided in web.xml");
            }
            this.addResourceEnvReferenceDescriptor(jdRef);
        }
    }

    protected void combineMessageDestinationReferenceDescriptors(JndiNameEnvironment env) {
        for (MessageDestinationReferenceDescriptor mdRef : env.getMessageDestinationReferenceDescriptors()) {
            WebFragmentDescriptor fragment;
            MessageDestinationReferenceDescriptor mdr = this.findMessageDestinationReferenceByName(mdRef.getName());
            if (mdr != null) {
                this.combineInjectionTargets(mdr, mdRef);
                continue;
            }
            if (env instanceof WebFragmentDescriptor && (fragment = (WebFragmentDescriptor)env).isConflictMessageDestinationReference()) {
                throw new IllegalArgumentException("There are more than one message destination references defined in web fragments with the same name, but not overrided in web.xml");
            }
            this.addMessageDestinationReferenceDescriptor(mdRef);
        }
    }

    protected void combineEntityManagerReferenceDescriptors(JndiNameEnvironment env) {
        for (EntityManagerReferenceDescriptor emRef : env.getEntityManagerReferenceDescriptors()) {
            WebFragmentDescriptor fragment;
            EntityManagerReferenceDescriptor emr = this.findEntityManagerReferenceByName(emRef.getName());
            if (emr != null) {
                this.combineInjectionTargets(emr, emRef);
                continue;
            }
            if (env instanceof WebFragmentDescriptor && (fragment = (WebFragmentDescriptor)env).isConflictEntityManagerReference()) {
                throw new IllegalArgumentException("There are more than one persistence context references defined in web fragments with the same name, but not overrided in web.xml");
            }
            this.addEntityManagerReferenceDescriptor(emRef);
        }
    }

    protected void combineEntityManagerFactoryReferenceDescriptors(JndiNameEnvironment env) {
        for (EntityManagerFactoryReferenceDescriptor emfRef : env.getEntityManagerFactoryReferenceDescriptors()) {
            WebFragmentDescriptor fragment;
            EntityManagerFactoryReferenceDescriptor emfr = this.findEntityManagerFactoryReferenceByName(emfRef.getName());
            if (emfr != null) {
                this.combineInjectionTargets(emfr, emfRef);
                continue;
            }
            if (env instanceof WebFragmentDescriptor && (fragment = (WebFragmentDescriptor)env).isConflictEntityManagerFactoryReference()) {
                throw new IllegalArgumentException("There are more than one persistence unit references defined in web fragments with the same name, but not overrided in web.xml");
            }
            this.addEntityManagerFactoryReferenceDescriptor(emfRef);
        }
    }

    private void combineAllResourceDescriptors(JndiNameEnvironment env) {
        for (JavaEEResourceType javaEEResourceType : JavaEEResourceType.values()) {
            this.combineResourceDescriptors(env, javaEEResourceType);
        }
    }

    protected void combineResourceDescriptors(JndiNameEnvironment env, JavaEEResourceType javaEEResourceType) {
        for (ResourceDescriptor desc : env.getResourceDescriptors(javaEEResourceType)) {
            ResourceDescriptor descriptor = this.getResourceDescriptor(javaEEResourceType, desc.getName());
            if (descriptor != null) continue;
            if (env instanceof WebFragmentDescriptor) {
                WebFragmentDescriptor fragment = (WebFragmentDescriptor)env;
                if (javaEEResourceType.equals((Object)JavaEEResourceType.AODD) && fragment.isConflictAdminObjectDefinition()) {
                    throw new IllegalArgumentException("There are more than one administered object definitions defined in web fragments with the same name, but not overrided in web.xml");
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.MSD) && fragment.isConflictMailSessionDefinition()) {
                    throw new IllegalArgumentException("There are more than one mail-session definitions defined in web fragments with the same name, but not overrided in web.xml");
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.DSD) && fragment.isConflictDataSourceDefinition()) {
                    throw new IllegalArgumentException("There are more than one datasource definitions defined in web fragments with the same name, but not overrided in web.xml");
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.CFD) && fragment.isConflictConnectionFactoryDefinition()) {
                    throw new IllegalArgumentException("There are more than one connection factory definitions defined in web fragments with the same name, but not overrided in web.xml");
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.JMSCFDD) && fragment.isConflictJMSConnectionFactoryDefinition()) {
                    throw new IllegalArgumentException("There are more than one jms connection factory definitions defined in web fragments with the same name, but not overrided in web.xml");
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.JMSDD) && fragment.isConflictJMSDestinationDefinition()) {
                    throw new IllegalArgumentException("There are more than one jms destination definitions defined in web fragments with the same name, but not overrided in web.xml");
                }
            }
            if (!desc.getResourceType().equals((Object)JavaEEResourceType.DSD) && !desc.getResourceType().equals((Object)JavaEEResourceType.MSD) && !desc.getResourceType().equals((Object)JavaEEResourceType.CFD) && !desc.getResourceType().equals((Object)JavaEEResourceType.AODD) && !desc.getResourceType().equals((Object)JavaEEResourceType.JMSCFDD) && !desc.getResourceType().equals((Object)JavaEEResourceType.JMSDD)) continue;
            this.getResourceDescriptors(javaEEResourceType).add(desc);
        }
    }

    protected void combineInjectionTargets(EnvironmentProperty env1, EnvironmentProperty env2) {
        for (InjectionTarget injTarget : env2.getInjectionTargets()) {
            env1.addInjectionTarget(injTarget);
        }
    }

    @Override
    public void addWebComponentDescriptor(WebComponentDescriptor webComponentDescriptor) {
        String servletName = webComponentDescriptor.getCanonicalName();
        webComponentDescriptor.setWebBundleDescriptor(this);
        WebComponentDescriptor resultDesc = this.combineWebComponentDescriptor(webComponentDescriptor);
        for (String up : resultDesc.getUrlPatternsSet()) {
            String oldName = this.getUrlPatternToServletNameMap(true).put(up, servletName);
            if (oldName == null || oldName.equals(servletName)) continue;
            throw new IllegalArgumentException(MessageFormat.format("Servlet [{0}] and Servlet [{1}] have the same url pattern: [{2}]", oldName, servletName, up));
        }
    }

    protected WebComponentDescriptor combineWebComponentDescriptor(WebComponentDescriptor webComponentDescriptor) {
        WebComponentDescriptor resultDesc;
        String name = webComponentDescriptor.getCanonicalName();
        WebComponentDescriptor webCompDesc = this.getWebComponentByCanonicalName(name);
        if (webCompDesc != null) {
            resultDesc = webCompDesc;
            if (!webCompDesc.isConflict(webComponentDescriptor, true)) {
                webCompDesc.add(webComponentDescriptor, false, false);
            }
            String implFile = webCompDesc.getWebComponentImplementation();
            if (resultDesc.isConflict() && (implFile == null || implFile.isEmpty())) {
                throw new IllegalArgumentException("Two or more web fragments define the same Servlet with conflicting implementation class names that are not overridden by the web.xml");
            }
            if (!resultDesc.getConflictedInitParameterNames().isEmpty()) {
                throw new IllegalArgumentException("Two or more web fragments define the same Servlet with conflicting init param that are not overridden by the web.xml");
            }
        } else {
            resultDesc = webComponentDescriptor;
            if (resultDesc.isConflict()) {
                throw new IllegalArgumentException("One or more web fragments define the same Servlet in a conflicting way, and the Servlet is not defined in web.xml");
            }
            super.addWebComponentDescriptor(resultDesc);
        }
        return resultDesc;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        if (this.sunWebApp != null) {
            toStringBuffer.append("\n ========== Runtime Descriptors =========");
            toStringBuffer.append('\n').append(this.sunWebApp);
        }
    }

    public Enumeration<String> getArchiveFileEntries(ReadableArchive archiveFile) {
        return archiveFile.entries();
    }

    private static final class ServletFilterMappingInfo {
        private ServletFilterMapping servletFilterMapping;
        private boolean hasMapping;
        private boolean hasDispatcher;

        private ServletFilterMappingInfo() {
        }
    }
}

