/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.Engine;
import java.util.Collections;
import java.util.List;
import org.glassfish.web.config.serverbeans.ContextParam;
import org.glassfish.web.config.serverbeans.EnvEntry;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.TransactionFailure;

@Configured
public interface WebModuleConfig
extends ConfigBeanProxy,
ApplicationConfig {
    @Element
    public List<EnvEntry> getEnvEntry();

    @Element
    public List<ContextParam> getContextParam();

    default public EnvEntry getEnvEntry(String name) {
        for (EnvEntry entry : this.getEnvEntry()) {
            if (!entry.getEnvEntryName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    default public ContextParam getContextParam(String name) {
        for (ContextParam param : this.getContextParam()) {
            if (!param.getParamName().equals(name)) continue;
            return param;
        }
        return null;
    }

    default public void deleteEnvEntry(String name) throws TransactionFailure {
        EnvEntry entry = this.getEnvEntry(name);
        if (entry == null) {
            return;
        }
        ConfigSupport.apply(config -> config.getEnvEntry().remove(entry), this);
    }

    default public void deleteContextParam(String name) throws TransactionFailure {
        ContextParam param = this.getContextParam(name);
        if (param == null) {
            return;
        }
        ConfigSupport.apply(config -> config.getContextParam().remove(param), this);
    }

    default public List<EnvEntry> envEntriesMatching(String nameOrNull) {
        EnvEntry entry;
        List<Object> result = nameOrNull != null ? ((entry = this.getEnvEntry(nameOrNull)) == null ? List.of() : List.of(entry)) : Collections.unmodifiableList(this.getEnvEntry());
        return result;
    }

    default public List<ContextParam> contextParamsMatching(String nameOrNull) {
        ContextParam param;
        List<Object> result = nameOrNull != null ? ((param = this.getContextParam(nameOrNull)) == null ? List.of() : List.of(param)) : Collections.unmodifiableList(this.getContextParam());
        return result;
    }

    public static WebModuleConfig webModuleConfig(Engine engine) {
        return (WebModuleConfig)engine.getApplicationConfig();
    }
}

