/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.config;

import com.sun.enterprise.admin.commands.CreateSsl;
import com.sun.enterprise.admin.commands.DeleteSsl;
import com.sun.enterprise.admin.commands.SslConfigHandler;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.glassfish.api.ActionReport;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.web.LogFacade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="http-listener")
public class WebSslConfigHandler
implements SslConfigHandler {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();

    @Override
    public void create(final CreateSsl command, ActionReport report) {
        NetworkConfig netConfig = command.config.getNetworkConfig();
        NetworkListener listener = netConfig.getNetworkListener(command.listenerId);
        try {
            Protocol httpProtocol;
            if (listener == null) {
                report.setMessage(MessageFormat.format(rb.getString("AS-WEB-GLUE-00272"), command.listenerId));
                httpProtocol = command.findOrCreateProtocol(command.listenerId);
            } else {
                httpProtocol = listener.findHttpProtocol();
                Ssl ssl = httpProtocol.getSsl();
                if (ssl != null) {
                    report.setMessage(MessageFormat.format(rb.getString("AS-WEB-GLUE-00273"), command.listenerId));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) throws TransactionFailure {
                    Ssl newSsl = param.createChild(Ssl.class);
                    command.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, httpProtocol);
        }
        catch (TransactionFailure e) {
            command.reportError(report, e);
        }
        command.reportSuccess(report);
    }

    @Override
    public void delete(DeleteSsl command, ActionReport report) {
        NetworkConfig netConfig = command.config.getNetworkConfig();
        NetworkListener networkListener = netConfig.getNetworkListener(command.listenerId);
        if (networkListener == null) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-GLUE-00274"), command.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Protocol protocol = networkListener.findHttpProtocol();
        if (protocol.getSsl() == null) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-GLUE-00275"), command.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Protocol>(this){

                @Override
                public Object run(Protocol param) {
                    param.setSsl(null);
                    return null;
                }
            }, networkListener.findHttpProtocol());
        }
        catch (TransactionFailure e) {
            command.reportError(report, e);
        }
    }
}

