/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-http-listeners")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.http.listeners")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HttpService.class, opType=RestEndpoint.OpType.GET, path="list-http-listeners", description="list-http-listeners")})
public class ListHttpListeners
implements AdminCommand {
    @Param(primary=true, optional=true, defaultValue="server")
    String target;
    @Param(optional=true, defaultValue="false", name="long", shortName="l")
    boolean verbose;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;

    @Override
    public void execute(AdminCommandContext context) {
        Target targetUtil = this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        List<NetworkListener> list = this.config.getNetworkConfig().getNetworkListeners().getNetworkListener();
        int size = 0;
        for (NetworkListener networkListener : list) {
            size = Math.max(size, networkListener.getName().length());
        }
        String format = "%-" + (size + 2) + "s %-6s";
        if (this.verbose) {
            report.getTopMessagePart().addChild().setMessage(String.format(format, "NAME", "PORT"));
        }
        for (NetworkListener listener : list) {
            if (listener.findHttpProtocol().getHttp() == null) continue;
            report.getTopMessagePart().addChild().setMessage(String.format(format, listener.getName(), this.verbose ? listener.getPort() : ""));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

