/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.tag.common.xml;

import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.glassfish.wasp.taglibs.standard.resources.Resources;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.DocumentBuilderProvider;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.ForEachTag;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.JSTLNodeList;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.JSTLXPathConstants;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.JSTLXPathFactory;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.JSTLXPathNamespaceContext;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.JSTLXPathVariableResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathUtil {
    private static final String PAGE_NS_URL = "http://java.sun.com/jstl/xpath/page";
    private static final String REQUEST_NS_URL = "http://java.sun.com/jstl/xpath/request";
    private static final String SESSION_NS_URL = "http://java.sun.com/jstl/xpath/session";
    private static final String APP_NS_URL = "http://java.sun.com/jstl/xpath/app";
    private static final String PARAM_NS_URL = "http://java.sun.com/jstl/xpath/param";
    private static final String INITPARAM_NS_URL = "http://java.sun.com/jstl/xpath/initParam";
    private static final String COOKIE_NS_URL = "http://java.sun.com/jstl/xpath/cookie";
    private static final String HEADER_NS_URL = "http://java.sun.com/jstl/xpath/header";
    private static final XPathFactory XPATH_FACTORY = new JSTLXPathFactory();
    private static final JSTLXPathNamespaceContext JSTL_XPATH_NS_CTX = XPathUtil.initXPathNamespaceContext();
    private final PageContext pageContext;

    public XPathUtil(PageContext pc) {
        this.pageContext = pc;
    }

    public String valueOf(Node contextNode, String xpathString) throws JspTagException {
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(JSTL_XPATH_NS_CTX);
        xpath.setXPathVariableResolver(new JSTLXPathVariableResolver(this.pageContext));
        try {
            return xpath.evaluate(xpathString, contextNode);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    public boolean booleanValueOf(Node contextNode, String xpathString) throws JspTagException {
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(JSTL_XPATH_NS_CTX);
        xpath.setXPathVariableResolver(new JSTLXPathVariableResolver(this.pageContext));
        try {
            return (Boolean)xpath.evaluate(xpathString, contextNode, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(Resources.getMessage("XPATH_ERROR_XOBJECT", ex.toString()), ex);
        }
    }

    public List<Object> selectNodes(Node contextNode, String xpathString) throws JspTagException {
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(JSTL_XPATH_NS_CTX);
            xpath.setXPathVariableResolver(new JSTLXPathVariableResolver(this.pageContext));
            Object nl = xpath.evaluate(xpathString, contextNode, JSTLXPathConstants.OBJECT);
            return new JSTLNodeList(nl);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    public Node selectSingleNode(Node contextNode, String xpathString) throws JspTagException {
        JSTLXPathVariableResolver jxvr = new JSTLXPathVariableResolver(this.pageContext);
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(JSTL_XPATH_NS_CTX);
            xpath.setXPathVariableResolver(jxvr);
            return (Node)xpath.evaluate(xpathString, contextNode, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    public static Node getContext(Tag t) throws JspTagException {
        ForEachTag xt = (ForEachTag)TagSupport.findAncestorWithClass(t, ForEachTag.class);
        if (xt == null) {
            return XPathUtil.newEmptyDocument();
        }
        return xt.getContext();
    }

    private static JSTLXPathNamespaceContext initXPathNamespaceContext() {
        JSTLXPathNamespaceContext context = new JSTLXPathNamespaceContext();
        context.addNamespace("pageScope", PAGE_NS_URL);
        context.addNamespace("requestScope", REQUEST_NS_URL);
        context.addNamespace("sessionScope", SESSION_NS_URL);
        context.addNamespace("applicationScope", APP_NS_URL);
        context.addNamespace("param", PARAM_NS_URL);
        context.addNamespace("initParam", INITPARAM_NS_URL);
        context.addNamespace("header", HEADER_NS_URL);
        context.addNamespace("cookie", COOKIE_NS_URL);
        return context;
    }

    private static Document newEmptyDocument() {
        return DocumentBuilderProvider.createDocumentBuilder().newDocument();
    }
}

