/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.monitoring.ApplicationEventListener;
import org.glassfish.tyrus.core.uri.internal.PathSegment;
import org.glassfish.tyrus.core.uri.internal.UriComponent;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.servlet.TyrusServletFilter;
import org.glassfish.tyrus.servlet.TyrusServletUpgrade;
import org.glassfish.tyrus.spi.WebSocketEngine;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class TyrusServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(TyrusServletContainerInitializer.class.getName());
    private static final Set<Class<?>> FILTERED_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(TyrusServerConfiguration.class);
        }
    };

    @Override
    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        if (ctx.getAttribute(ServerContainer.class.getName()) != null) {
            return;
        }
        classes.removeAll(FILTERED_CLASSES);
        TyrusServletContainerData data = new TyrusServletContainerData(ctx);
        TyrusServerContainerImpl serverContainer = new TyrusServerContainerImpl(classes, data, ctx.getContextPath());
        ctx.setAttribute(ServerContainer.class.getName(), serverContainer);
        TyrusServletFilter filter = new TyrusServletFilter(serverContainer.getServletUpgrade());
        ctx.addListener(filter);
        FilterRegistration.Dynamic reg = ctx.addFilter("WebSocket filter", filter);
        reg.setAsyncSupported(true);
        reg.addMappingForUrlPatterns(null, true, "/*");
        LOGGER.info("Registering WebSocket filter for url pattern /*");
        if (data.applicationEventListener != null) {
            data.applicationEventListener.onApplicationInitialized(ctx.getContextPath());
        }
    }

    private static class TyrusServletContainerData {
        private final ApplicationEventListener applicationEventListener;
        private final Integer incomingBufferSize;
        private final Integer maxSessionsPerApp;
        private final Integer maxSessionsPerRemoteAddr;
        private final Boolean parallelBroadcastEnabled;
        private final DebugContext.TracingType tracingType;
        private final DebugContext.TracingThreshold tracingThreshold;
        private final Map<String, Object> properties;
        private Boolean wsadlEnabled;

        private TyrusServletContainerData(ServletContext ctx) {
            this.incomingBufferSize = TyrusServletContainerData.getIntContextParam(ctx, "org.glassfish.tyrus.servlet.incoming-buffer-size");
            this.maxSessionsPerApp = TyrusServletContainerData.getIntContextParam(ctx, "org.glassfish.tyrus.maxSessionsPerApp");
            this.maxSessionsPerRemoteAddr = TyrusServletContainerData.getIntContextParam(ctx, "org.glassfish.tyrus.maxSessionsPerRemoteAddr");
            this.parallelBroadcastEnabled = TyrusServletContainerData.getBooleanContextParam(ctx, "org.glassfish.tyrus.server.parallelBroadcastEnabled");
            this.tracingType = TyrusServletContainerData.getEnumContextParam(ctx, "org.glassfish.tyrus.server.tracingType", DebugContext.TracingType.class, DebugContext.TracingType.OFF);
            this.tracingThreshold = TyrusServletContainerData.getEnumContextParam(ctx, "org.glassfish.tyrus.server.tracingThreshold", DebugContext.TracingThreshold.class, DebugContext.TracingThreshold.TRACE);
            this.wsadlEnabled = TyrusServletContainerData.getBooleanContextParam(ctx, "org.glassfish.tyrus.server.wsadl");
            if (this.wsadlEnabled == null) {
                this.wsadlEnabled = false;
            }
            LOGGER.config("WSADL enabled: " + this.wsadlEnabled);
            this.applicationEventListener = TyrusServletContainerData.createApplicationEventListener(ctx);
            this.properties = TyrusServletContainerData.getProperties(ctx);
        }

        private static Integer getIntContextParam(ServletContext ctx, String paramName) {
            String initParameter = ctx.getInitParameter(paramName);
            if (initParameter != null) {
                try {
                    return Integer.parseInt(initParameter);
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.CONFIG, "Invalid configuration value [" + paramName + " = " + initParameter + "], integer expected");
                }
            }
            return null;
        }

        private static Boolean getBooleanContextParam(ServletContext ctx, String paramName) {
            String initParameter = ctx.getInitParameter(paramName);
            if (initParameter != null) {
                if (initParameter.equalsIgnoreCase("true")) {
                    return true;
                }
                if (initParameter.equalsIgnoreCase("false")) {
                    return false;
                }
                LOGGER.log(Level.CONFIG, "Invalid configuration value [" + paramName + " = " + initParameter + "], boolean expected");
                return null;
            }
            return null;
        }

        private static <T extends Enum<T>> T getEnumContextParam(ServletContext ctx, String paramName, Class<T> type2, T defaultValue) {
            String initParameter = ctx.getInitParameter(paramName);
            if (initParameter == null) {
                return defaultValue;
            }
            try {
                return Enum.valueOf(type2, initParameter.trim().toUpperCase(Locale.US));
            }
            catch (Exception e) {
                LOGGER.log(Level.CONFIG, "Invalid configuration value [" + paramName + " = " + initParameter + "]");
                return defaultValue;
            }
        }

        private static ApplicationEventListener createApplicationEventListener(ServletContext ctx) {
            String listenerClassName = ctx.getInitParameter("org.glassfish.tyrus.core.monitoring.ApplicationEventListener");
            if (listenerClassName == null) {
                return null;
            }
            try {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> listenerClass = Class.forName(listenerClassName, true, contextClassLoader);
                Object o = listenerClass.newInstance();
                if (o instanceof ApplicationEventListener) {
                    return (ApplicationEventListener)o;
                }
                LOGGER.log(Level.WARNING, "Class " + listenerClassName + " does not implement ApplicationEventListener");
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.WARNING, "ApplicationEventListener implementation " + listenerClassName + " not found", e);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.log(Level.WARNING, "ApplicationEventListener implementation " + listenerClassName + " could not have been instantiated", e);
            }
            return null;
        }

        private static Map<String, Object> getProperties(ServletContext ctx) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            Enumeration<String> nameEnumeration = ctx.getInitParameterNames();
            while (nameEnumeration.hasMoreElements()) {
                String name = nameEnumeration.nextElement();
                properties.put(name, ctx.getInitParameter(name));
            }
            return properties;
        }
    }

    private static class TyrusServerContainerImpl
    extends TyrusServerContainer {
        private final TyrusServletContainerData containerData;
        private final String contextPath;
        private final WebSocketEngine engine;
        private final TyrusServletUpgrade tyrusServletUpgrade;

        public TyrusServerContainerImpl(Set<Class<?>> set, TyrusServletContainerData data, String contextPath) {
            super(set);
            this.containerData = data;
            this.contextPath = contextPath;
            this.engine = TyrusWebSocketEngine.builder(this).applicationEventListener(data.applicationEventListener).incomingBufferSize(data.incomingBufferSize).maxSessionsPerApp(data.maxSessionsPerApp).maxSessionsPerRemoteAddr(data.maxSessionsPerRemoteAddr).parallelBroadcastEnabled(data.parallelBroadcastEnabled).tracingType(data.tracingType).tracingThreshold(data.tracingThreshold).build();
            this.tyrusServletUpgrade = new TyrusServletUpgrade((TyrusWebSocketEngine)this.engine, data.wsadlEnabled);
        }

        @Override
        public void register(Class<?> endpointClass) throws DeploymentException {
            this.engine.register(endpointClass, this.contextPath);
        }

        @Override
        public void register(ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
            this.engine.register(serverEndpointConfig, this.contextPath);
        }

        @Override
        public WebSocketEngine getWebSocketEngine() {
            return this.engine;
        }

        @Override
        public void upgradeHttpToWebSocket(Object servletRequest, Object servletResponse, ServerEndpointConfig sec, Map<String, String> pathParameters) throws IOException, DeploymentException {
            final String requestUri = TyrusServerContainerImpl.computeRequestPath(sec.getPath(), pathParameters);
            HttpServletRequestWrapper httpServletRequest = new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

                @Override
                public String getRequestURI() {
                    return contextPath + requestUri;
                }

                @Override
                public String getContextPath() {
                    return "/";
                }
            };
            try {
                this.tyrusServletUpgrade.upgrade(httpServletRequest, (HttpServletResponse)servletResponse);
            }
            catch (ServletException e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }

        private TyrusServletUpgrade getServletUpgrade() {
            return this.tyrusServletUpgrade;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.containerData.properties;
        }

        private static String computeRequestPath(String path, Map<String, String> pathParams) {
            StringBuilder resultPath = new StringBuilder();
            List<PathSegment> endpointPathSegments = UriComponent.decodePath(path, true);
            for (int i = 0; i < endpointPathSegments.size(); ++i) {
                resultPath.append('/');
                String endpointSegment = endpointPathSegments.get(i).getPath();
                if (TyrusServerContainerImpl.isVariable(endpointSegment)) {
                    String pathParam = pathParams.get(TyrusServerContainerImpl.getVariableName(endpointSegment));
                    resultPath.append(pathParam == null ? endpointSegment : pathParam);
                    continue;
                }
                resultPath.append(endpointSegment);
            }
            String result = resultPath.toString();
            return result.startsWith("//") ? result.substring(1) : result;
        }

        private static boolean isVariable(String segment) {
            return segment.startsWith("{") && segment.endsWith("}");
        }

        private static String getVariableName(String segment) {
            return segment.substring(1, segment.length() - 1);
        }
    }
}

