/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.servlet;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.glassfish.soteria.Utils;

public class RequestData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Cookie[] cookies;
    private Map<String, List<String>> headers;
    private Map<String, String[]> parameters;
    private List<Locale> locales;
    private String method;
    private String requestURL;
    private String queryString;

    public static RequestData of(HttpServletRequest request) {
        RequestData requestData = new RequestData();
        requestData.cookies = RequestData.copyCookies(request.getCookies());
        requestData.headers = RequestData.copyHeaders(request);
        requestData.parameters = RequestData.copyParameters(request.getParameterMap());
        requestData.locales = Collections.list(request.getLocales());
        requestData.method = request.getMethod();
        requestData.requestURL = request.getRequestURL().toString();
        requestData.queryString = request.getQueryString();
        return requestData;
    }

    public static RequestData of(String json) {
        RequestData requestData = new RequestData();
        JsonObject jsonRootObject = Json.createReader(new StringReader(json)).readObject();
        ArrayList<Cookie> copiedCookies = new ArrayList<Cookie>();
        JsonArray cookiesArray = jsonRootObject.getJsonArray("cookies");
        if (cookiesArray != null) {
            for (JsonValue jsonCookie : cookiesArray) {
                copiedCookies.add(new Cookie(jsonCookie.asJsonObject().getString("name"), jsonCookie.asJsonObject().getString("value")));
            }
            requestData.cookies = (Cookie[])copiedCookies.toArray(Cookie[]::new);
        }
        HashMap<String, List<String>> copiedHeaders = new HashMap<String, List<String>>();
        JsonObject jsonHeaders = jsonRootObject.getJsonObject("headers");
        if (jsonHeaders != null) {
            for (Map.Entry headerEntry : jsonHeaders.entrySet()) {
                copiedHeaders.put((String)headerEntry.getKey(), RequestData.toStringList((JsonValue)headerEntry.getValue()));
            }
            requestData.headers = copiedHeaders;
        }
        HashMap<String, String[]> copiedParameters = new HashMap<String, String[]>();
        JsonObject jsonParameters = jsonRootObject.getJsonObject("parameters");
        if (jsonParameters != null) {
            for (Map.Entry parameterEntry : jsonParameters.entrySet()) {
                copiedParameters.put((String)parameterEntry.getKey(), RequestData.toStringArray((JsonValue)parameterEntry.getValue()));
            }
            requestData.headers = copiedHeaders;
        }
        ArrayList<Locale> copiedLocales = new ArrayList<Locale>();
        JsonArray jsonLocales = jsonRootObject.getJsonArray("locales");
        if (cookiesArray != null) {
            for (JsonValue jsonLocale : jsonLocales) {
                JsonObject jsonLocaleObject = jsonLocale.asJsonObject();
                copiedLocales.add(new Locale(jsonLocaleObject.getString("name"), jsonLocaleObject.getString("country"), jsonLocaleObject.getString("variant")));
            }
        }
        requestData.method = jsonRootObject.getString("method");
        requestData.requestURL = jsonRootObject.getString("requestURL");
        requestData.queryString = jsonRootObject.getString("queryString");
        return requestData;
    }

    private static List<String> toStringList(JsonValue value) {
        return value.asJsonArray().stream().map(JsonString.class::cast).map(e -> e.getString()).collect(Collectors.toList());
    }

    private static String[] toStringArray(JsonValue value) {
        return (String[])RequestData.toStringList(value).toArray(String[]::new);
    }

    public String toJson() {
        JsonArrayBuilder cookiesBuilder = Json.createArrayBuilder();
        if (this.cookies != null) {
            for (Cookie cookie : this.cookies) {
                cookiesBuilder.add(Json.createObjectBuilder().add("name", cookie.getName()).add("value", cookie.getValue()).add("attributes", Json.createObjectBuilder(cookie.getAttributes())));
            }
        }
        JsonArrayBuilder localesBuilder = Json.createArrayBuilder();
        for (Locale locale : this.locales) {
            localesBuilder.add(Json.createObjectBuilder().add("name", locale.getLanguage()).add("country", locale.getCountry()).add("variant", locale.getVariant()));
        }
        return Json.createObjectBuilder().add("cookies", cookiesBuilder).add("headers", Json.createObjectBuilder(this.headers)).add("parameters", Json.createObjectBuilder(this.parameters)).add("locales", localesBuilder).add("method", this.nullSafe(this.method)).add("requestURL", this.nullSafe(this.requestURL)).add("queryString", this.nullSafe(this.queryString)).build().toString();
    }

    private String nullSafe(String string) {
        return string != null ? string : "";
    }

    private static Cookie[] copyCookies(Cookie[] cookies) {
        if (Utils.isEmpty(cookies)) {
            return cookies;
        }
        ArrayList<Cookie> copiedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            copiedCookies.add((Cookie)cookie.clone());
        }
        return copiedCookies.toArray(new Cookie[copiedCookies.size()]);
    }

    private static Map<String, List<String>> copyHeaders(HttpServletRequest request) {
        HashMap<String, List<String>> copiedHeaders = new HashMap<String, List<String>>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            copiedHeaders.put(headerName, Collections.list(request.getHeaders(headerName)));
        }
        return copiedHeaders;
    }

    private static Map<String, String[]> copyParameters(Map<String, String[]> parameters) {
        if (RequestData.isEmptyMap(parameters)) {
            return Collections.emptyMap();
        }
        HashMap<String, String[]> copiedParameters = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> parameter : parameters.entrySet()) {
            copiedParameters.put(parameter.getKey(), Arrays.copyOf(parameter.getValue(), parameter.getValue().length));
        }
        return copiedParameters;
    }

    private static boolean isEmptyMap(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getFullRequestURL() {
        return this.buildFullRequestURL(this.requestURL, this.queryString);
    }

    public boolean matchesRequest(HttpServletRequest request) {
        return this.getFullRequestURL().equals(this.buildFullRequestURL(request.getRequestURL().toString(), request.getQueryString()));
    }

    public String toString() {
        return String.format("%s %s", this.method, this.getFullRequestURL());
    }

    private String buildFullRequestURL(String requestURL, String queryString) {
        return requestURL + (String)(Utils.isEmpty(queryString) ? "" : "?" + queryString);
    }
}

